/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.chart;

import eu.hansolo.tilesfx.chart.MatrixFont;
import eu.hansolo.tilesfx.chart.PixelMatrix;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class PixelMatrixBuilder<B extends PixelMatrixBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected PixelMatrixBuilder() {
    }

    public static final PixelMatrixBuilder create() {
        return new PixelMatrixBuilder();
    }

    public final B colsAndRows(int[] COLS_AND_ROWS) {
        return this.colsAndRows(COLS_AND_ROWS[0], COLS_AND_ROWS[1]);
    }

    public final B colsAndRows(int COLS, int ROWS) {
        this.properties.put("cols", (Property)new SimpleIntegerProperty(COLS));
        this.properties.put("rows", (Property)new SimpleIntegerProperty(ROWS));
        return (B)this;
    }

    public final B pixelOnColor(Color COLOR) {
        this.properties.put("pixelOnColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B pixelOffColor(Color COLOR) {
        this.properties.put("pixelOffColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B pixelShape(PixelMatrix.PixelShape SHAPE) {
        this.properties.put("pixelShape", (Property)new SimpleObjectProperty((Object)SHAPE));
        return (B)this;
    }

    public final B matrixFont(MatrixFont FONT) {
        this.properties.put("matrixFont", (Property)new SimpleObjectProperty((Object)FONT));
        return (B)this;
    }

    public final B useSpacer(boolean USE) {
        this.properties.put("useSpacer", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B squarePixels(boolean SQUARE) {
        this.properties.put("squarePixels", (Property)new SimpleBooleanProperty(SQUARE));
        return (B)this;
    }

    public final B spacerSizeFactor(double FACTOR) {
        this.properties.put("spacerSizeFactor", (Property)new SimpleDoubleProperty(FACTOR));
        return (B)this;
    }

    public final B innerShadowEnabled(boolean ENABLED) {
        this.properties.put("innerShadowEnabled", (Property)new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final PixelMatrix build() {
        PixelMatrix CONTROL;
        if (this.properties.keySet().contains("cols") && this.properties.keySet().contains("rows")) {
            int cols = ((IntegerProperty)this.properties.get("cols")).get();
            int rows = ((IntegerProperty)this.properties.get("rows")).get();
            CONTROL = new PixelMatrix(cols, rows);
        } else {
            CONTROL = new PixelMatrix();
        }
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setMinSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setMaxSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("padding".equals(key)) {
                CONTROL.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("pixelOnColor".equals(key)) {
                CONTROL.setPixelOnColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("pixelOffColor".equals(key)) {
                CONTROL.setPixelOffColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("pixelShape".equals(key)) {
                CONTROL.setPixelShape((PixelMatrix.PixelShape)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("matrixFont".equals(key)) {
                CONTROL.setMatrixFont((MatrixFont)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("useSpacer".equals(key)) {
                CONTROL.setUseSpacer(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("spacerSizeFactor".equals(key)) {
                CONTROL.setSpacerSizeFactor(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("squarePixels".equals(key)) {
                CONTROL.setSquarePixels(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"innerShadowEnabled".equals(key)) continue;
            CONTROL.setInnerShadowEnabled(((BooleanProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

