/*
 * Decompiled with CFR 0.152.
 */
package feed;

import feed.Feed;
import feed.FeedMessage;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\f"}, d2={"Lfeed/RSSFeedParser;", "", "()V", "getCharacterData", "", "eventReader", "Ljavax/xml/stream/XMLEventReader;", "readFeed", "Lfeed/Feed;", "inputStream", "Ljava/io/InputStream;", "Companion", "MediathekView"})
public final class RSSFeedParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TITLE = "title";
    @NotNull
    private static final String DESCRIPTION = "description";
    @NotNull
    private static final String LANGUAGE = "language";
    @NotNull
    private static final String COPYRIGHT = "copyright";
    @NotNull
    private static final String LINK = "link";
    @NotNull
    private static final String AUTHOR = "author";
    @NotNull
    private static final String ITEM = "item";
    @NotNull
    private static final String PUB_DATE = "pubDate";
    @NotNull
    private static final String GUID = "guid";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Feed readFeed(@Nullable InputStream inputStream2) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        Feed feed = null;
        XMLEventReader eventReader = null;
        try {
            boolean isFeedHeader = true;
            String description = "";
            String title = "";
            String link = "";
            String language = "";
            String copyright = "";
            String author = "";
            String pubdate = "";
            String guid = "";
            eventReader = inputFactory.createXMLEventReader(inputStream2);
            while (eventReader.hasNext()) {
                XMLEvent event;
                block43: {
                    event = eventReader.nextEvent();
                    if (!event.isStartElement()) break block43;
                    String string = event.asStartElement().getName().getLocalPart();
                    if (string == null) continue;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 3242771: {
                            if (string.equals(ITEM)) {
                                n = 1;
                            }
                            break;
                        }
                        case 1522889671: {
                            if (string.equals(COPYRIGHT)) {
                                n = 2;
                            }
                            break;
                        }
                        case -1406328437: {
                            if (string.equals(AUTHOR)) {
                                n = 3;
                            }
                            break;
                        }
                        case 3321850: {
                            if (string.equals(LINK)) {
                                n = 4;
                            }
                            break;
                        }
                        case -1724546052: {
                            if (string.equals(DESCRIPTION)) {
                                n = 5;
                            }
                            break;
                        }
                        case 3184265: {
                            if (string.equals(GUID)) {
                                n = 6;
                            }
                            break;
                        }
                        case -1613589672: {
                            if (string.equals(LANGUAGE)) {
                                n = 7;
                            }
                            break;
                        }
                        case 110371416: {
                            if (string.equals(TITLE)) {
                                n = 8;
                            }
                            break;
                        }
                        case -236564405: {
                            if (string.equals(PUB_DATE)) {
                                n = 9;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            if (isFeedHeader) {
                                isFeedHeader = false;
                                feed = new Feed(title, link, description, language, copyright, pubdate);
                            }
                            eventReader.nextEvent();
                            break;
                        }
                        case 8: {
                            title = this.getCharacterData(eventReader);
                            break;
                        }
                        case 5: {
                            description = this.getCharacterData(eventReader);
                            break;
                        }
                        case 4: {
                            link = this.getCharacterData(eventReader);
                            break;
                        }
                        case 6: {
                            guid = this.getCharacterData(eventReader);
                            break;
                        }
                        case 7: {
                            language = this.getCharacterData(eventReader);
                            break;
                        }
                        case 3: {
                            author = this.getCharacterData(eventReader);
                            break;
                        }
                        case 9: {
                            pubdate = this.getCharacterData(eventReader);
                            break;
                        }
                        case 2: {
                            copyright = this.getCharacterData(eventReader);
                        }
                    }
                    continue;
                }
                if (!event.isEndElement() || !Intrinsics.areEqual(event.asEndElement().getName().getLocalPart(), ITEM)) continue;
                Object object = feed;
                if (object != null && (object = ((Feed)object).getMessages()) != null) {
                    ((ArrayList)object).add(new FeedMessage(title, description, link, author, guid));
                }
                eventReader.nextEvent();
            }
        }
        finally {
            if (eventReader != null) {
                try {
                    eventReader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        return feed;
    }

    private final String getCharacterData(XMLEventReader eventReader) throws XMLStreamException {
        String result = "";
        XMLEvent event = eventReader.nextEvent();
        if (event instanceof Characters) {
            String string = event.asCharacters().getData();
            Intrinsics.checkNotNullExpressionValue(string, "event.asCharacters().data");
            result = string;
        }
        return result;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lfeed/RSSFeedParser$Companion;", "", "()V", "AUTHOR", "", "COPYRIGHT", "DESCRIPTION", "GUID", "ITEM", "LANGUAGE", "LINK", "PUB_DATE", "TITLE", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

