/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.health;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateObserver;
import org.opensearch.cluster.ClusterStateTaskExecutor;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.LocalClusterUpdateTask;
import org.opensearch.cluster.NotClusterManagerException;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.coordination.Coordinator;
import org.opensearch.cluster.decommission.NodeDecommissionedException;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.NodeWeighedAwayException;
import org.opensearch.cluster.routing.UnassignedInfo;
import org.opensearch.cluster.routing.WeightedRoutingUtils;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.CollectionUtils;
import org.opensearch.core.common.Strings;
import org.opensearch.discovery.ClusterManagerNotDiscoveredException;
import org.opensearch.discovery.Discovery;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.node.NodeClosedException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportClusterHealthAction
extends TransportClusterManagerNodeReadAction<ClusterHealthRequest, ClusterHealthResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterHealthAction.class);
    private final AllocationService allocationService;
    private final Discovery discovery;

    @Inject
    public TransportClusterHealthAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AllocationService allocationService, Discovery discovery) {
        super("cluster:monitor/health", false, transportService, clusterService, threadPool, actionFilters, ClusterHealthRequest::new, indexNameExpressionResolver);
        this.allocationService = allocationService;
        this.discovery = discovery;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterHealthResponse read(StreamInput in) throws IOException {
        return new ClusterHealthResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterHealthRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected final void clusterManagerOperation(ClusterHealthRequest request, ClusterState state, ActionListener<ClusterHealthResponse> listener) throws Exception {
        logger.warn("attempt to execute a cluster health operation without a task");
        throw new UnsupportedOperationException("task parameter is required for this operation");
    }

    @Override
    protected void clusterManagerOperation(Task task, ClusterHealthRequest request, ClusterState unusedState, ActionListener<ClusterHealthResponse> listener) {
        if (request.ensureNodeWeighedIn() && this.discovery instanceof Coordinator && !((Coordinator)this.discovery).localNodeCommissioned()) {
            listener.onFailure((Exception)((Object)new NodeDecommissionedException("local node is decommissioned", new Object[0])));
            return;
        }
        int waitCount = TransportClusterHealthAction.getWaitCount(request);
        if (request.waitForEvents() != null) {
            this.waitForEventsAndExecuteHealth(request, listener, waitCount, this.threadPool.relativeTimeInMillis() + request.timeout().millis());
        } else {
            this.executeHealth(request, this.clusterService.state(), listener, waitCount, clusterState -> listener.onResponse(this.getResponse(request, (ClusterState)clusterState, waitCount, TimeoutState.OK)));
        }
    }

    private void waitForEventsAndExecuteHealth(final ClusterHealthRequest request, final ActionListener<ClusterHealthResponse> listener, final int waitCount, final long endTimeRelativeMillis) {
        assert (request.waitForEvents() != null);
        if (request.local()) {
            this.clusterService.submitStateUpdateTask("cluster_health (wait_for_events [" + request.waitForEvents() + "])", new LocalClusterUpdateTask(request.waitForEvents()){

                @Override
                public ClusterStateTaskExecutor.ClusterTasksResult<LocalClusterUpdateTask> execute(ClusterState currentState) {
                    return 1.unchanged();
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    long timeoutInMillis = Math.max(0L, endTimeRelativeMillis - TransportClusterHealthAction.this.threadPool.relativeTimeInMillis());
                    TimeValue newTimeout = TimeValue.timeValueMillis((long)timeoutInMillis);
                    request.timeout(newTimeout);
                    TransportClusterHealthAction.this.executeHealth(request, TransportClusterHealthAction.this.clusterService.state(), listener, waitCount, observedState -> TransportClusterHealthAction.this.waitForEventsAndExecuteHealth(request, listener, waitCount, endTimeRelativeMillis));
                }

                @Override
                public void onFailure(String source, Exception e) {
                    logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                    listener.onFailure(e);
                }
            });
        } else {
            final TimeValue taskTimeout = TimeValue.timeValueMillis((long)Math.max(0L, endTimeRelativeMillis - this.threadPool.relativeTimeInMillis()));
            this.clusterService.submitStateUpdateTask("cluster_health (wait_for_events [" + request.waitForEvents() + "])", new ClusterStateUpdateTask(request.waitForEvents()){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    return currentState;
                }

                @Override
                public TimeValue timeout() {
                    return taskTimeout;
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    long timeoutInMillis = Math.max(0L, endTimeRelativeMillis - TransportClusterHealthAction.this.threadPool.relativeTimeInMillis());
                    TimeValue newTimeout = TimeValue.timeValueMillis((long)timeoutInMillis);
                    request.timeout(newTimeout);
                    ClusterState appliedState = TransportClusterHealthAction.this.clusterService.state();
                    assert (newState.stateUUID().equals(appliedState.stateUUID())) : newState.stateUUID() + " vs " + appliedState.stateUUID();
                    TransportClusterHealthAction.this.executeHealth(request, appliedState, listener, waitCount, observedState -> TransportClusterHealthAction.this.waitForEventsAndExecuteHealth(request, listener, waitCount, endTimeRelativeMillis));
                }

                @Override
                public void onNoLongerClusterManager(String source) {
                    logger.trace("stopped being cluster-manager while waiting for events with priority [{}]. retrying.", (Object)request.waitForEvents());
                    listener.onFailure((Exception)((Object)new NotClusterManagerException("no longer cluster-manager. source: [" + source + "]")));
                }

                @Override
                public void onFailure(String source, Exception e) {
                    if (e instanceof ProcessClusterEventTimeoutException) {
                        listener.onResponse(TransportClusterHealthAction.this.getResponse(request, TransportClusterHealthAction.this.clusterService.state(), waitCount, TimeoutState.TIMED_OUT));
                    } else {
                        logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                        listener.onFailure(e);
                    }
                }
            });
        }
    }

    private void executeHealth(final ClusterHealthRequest request, ClusterState currentState, final ActionListener<ClusterHealthResponse> listener, final int waitCount, final Consumer<ClusterState> onNewClusterStateAfterDelay) {
        if (request.timeout().millis() == 0L) {
            listener.onResponse(this.getResponse(request, currentState, waitCount, TimeoutState.ZERO_TIMEOUT));
            return;
        }
        Predicate<ClusterState> validationPredicate = newState -> this.validateRequest(request, (ClusterState)newState, waitCount);
        if (validationPredicate.test(currentState)) {
            ClusterHealthResponse clusterHealthResponse = this.getResponse(request, currentState, waitCount, TimeoutState.OK);
            if (request.ensureNodeWeighedIn()) {
                if (!clusterHealthResponse.hasDiscoveredClusterManager()) {
                    listener.onFailure((Exception)((Object)new ClusterManagerNotDiscoveredException("cluster-manager not discovered")));
                    return;
                }
                DiscoveryNode localNode = currentState.getNodes().getLocalNode();
                if (localNode.isDataNode()) {
                    assert (request.local()) : "local node request false for request for local node weighed in";
                    boolean weighedAway = WeightedRoutingUtils.isWeighedAway(localNode.getId(), currentState);
                    if (weighedAway) {
                        listener.onFailure((Exception)((Object)new NodeWeighedAwayException("local node is weighed away", new Object[0])));
                        return;
                    }
                }
            }
            listener.onResponse(clusterHealthResponse);
        } else {
            final ClusterStateObserver observer = new ClusterStateObserver(currentState, this.clusterService, null, logger, this.threadPool.getThreadContext());
            ClusterStateObserver.Listener stateListener = new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState newState) {
                    onNewClusterStateAfterDelay.accept(newState);
                }

                @Override
                public void onClusterServiceClose() {
                    listener.onFailure((Exception)((Object)new NodeClosedException(TransportClusterHealthAction.this.clusterService.localNode())));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    listener.onResponse(TransportClusterHealthAction.this.getResponse(request, observer.setAndGetObservedState(), waitCount, TimeoutState.TIMED_OUT));
                }
            };
            observer.waitForNextChange(stateListener, validationPredicate, request.timeout());
        }
    }

    private static int getWaitCount(ClusterHealthRequest request) {
        int waitCount = 0;
        if (request.waitForStatus() != null) {
            ++waitCount;
        }
        if (request.waitForNoRelocatingShards()) {
            ++waitCount;
        }
        if (request.waitForNoInitializingShards()) {
            ++waitCount;
        }
        if (!request.waitForActiveShards().equals(ActiveShardCount.NONE)) {
            ++waitCount;
        }
        if (!request.waitForNodes().isEmpty()) {
            ++waitCount;
        }
        if (!CollectionUtils.isEmpty(request.indices())) {
            ++waitCount;
        }
        return waitCount;
    }

    private boolean validateRequest(ClusterHealthRequest request, ClusterState clusterState, int waitCount) {
        ClusterHealthResponse response = this.clusterHealth(request, clusterState, this.clusterService.getClusterManagerService().numberOfPendingTasks(), this.allocationService.getNumberOfInFlightFetches(), this.clusterService.getClusterManagerService().getMaxTaskWaitTime());
        return TransportClusterHealthAction.prepareResponse(request, response, clusterState, this.indexNameExpressionResolver) == waitCount;
    }

    private ClusterHealthResponse getResponse(ClusterHealthRequest request, ClusterState clusterState, int waitFor, TimeoutState timeoutState) {
        boolean valid;
        ClusterHealthResponse response = this.clusterHealth(request, clusterState, this.clusterService.getClusterManagerService().numberOfPendingTasks(), this.allocationService.getNumberOfInFlightFetches(), this.clusterService.getClusterManagerService().getMaxTaskWaitTime());
        int readyCounter = TransportClusterHealthAction.prepareResponse(request, response, clusterState, this.indexNameExpressionResolver);
        boolean bl = valid = readyCounter == waitFor;
        assert (valid || timeoutState != TimeoutState.OK);
        response.setTimedOut(!valid || timeoutState == TimeoutState.TIMED_OUT);
        return response;
    }

    static int prepareResponse(ClusterHealthRequest request, ClusterHealthResponse response, ClusterState clusterState, IndexNameExpressionResolver indexNameExpressionResolver) {
        int waitForCounter = 0;
        if (request.waitForStatus() != null && response.getStatus().value() <= request.waitForStatus().value()) {
            ++waitForCounter;
        }
        if (request.waitForNoRelocatingShards() && response.getRelocatingShards() == 0) {
            ++waitForCounter;
        }
        if (request.waitForNoInitializingShards() && response.getInitializingShards() == 0) {
            ++waitForCounter;
        }
        if (!request.waitForActiveShards().equals(ActiveShardCount.NONE)) {
            ActiveShardCount waitForActiveShards = request.waitForActiveShards();
            assert (!waitForActiveShards.equals(ActiveShardCount.DEFAULT)) : "waitForActiveShards must not be DEFAULT on the request object, instead it should be NONE";
            if (waitForActiveShards.equals(ActiveShardCount.ALL)) {
                if (response.getUnassignedShards() == 0 && response.getInitializingShards() == 0) {
                    ++waitForCounter;
                }
            } else if (waitForActiveShards.enoughShardsActive(response.getActiveShards())) {
                ++waitForCounter;
            }
        }
        if (!CollectionUtils.isEmpty(request.indices())) {
            try {
                indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.strictExpand(), request);
                ++waitForCounter;
            }
            catch (IndexNotFoundException e) {
                response.setStatus(ClusterHealthStatus.RED);
            }
        }
        if (!request.waitForNodes().isEmpty()) {
            if (request.waitForNodes().startsWith(">=")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(2));
                if (response.getNumberOfNodes() >= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("ge(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() >= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("<=")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(2));
                if (response.getNumberOfNodes() <= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("le(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() <= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith(">")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(1));
                if (response.getNumberOfNodes() > expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("gt(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() > expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("<")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(1));
                if (response.getNumberOfNodes() < expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("lt(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() < expected) {
                    ++waitForCounter;
                }
            } else {
                int expected = Integer.parseInt(request.waitForNodes());
                if (response.getNumberOfNodes() == expected) {
                    ++waitForCounter;
                }
            }
        }
        return waitForCounter;
    }

    private ClusterHealthResponse clusterHealth(ClusterHealthRequest request, ClusterState clusterState, int numberOfPendingTasks, int numberOfInFlightFetch, TimeValue pendingTaskTimeInQueue) {
        String[] concreteIndices;
        if (logger.isTraceEnabled()) {
            logger.trace("Calculating health based on state version [{}]", (Object)clusterState.version());
        }
        if (request.level().equals((Object)ClusterHealthRequest.Level.AWARENESS_ATTRIBUTES)) {
            String awarenessAttribute = request.getAwarenessAttribute();
            String[] concreteIndices2 = clusterState.getMetadata().getConcreteAllIndices();
            return new ClusterHealthResponse(clusterState.getClusterName().value(), clusterState, this.clusterService.getClusterSettings(), concreteIndices2, awarenessAttribute, numberOfPendingTasks, numberOfInFlightFetch, UnassignedInfo.getNumberOfDelayedUnassigned(clusterState), pendingTaskTimeInQueue);
        }
        try {
            concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(clusterState, request);
        }
        catch (IndexNotFoundException e) {
            ClusterHealthResponse response = new ClusterHealthResponse(clusterState.getClusterName().value(), Strings.EMPTY_ARRAY, clusterState, numberOfPendingTasks, numberOfInFlightFetch, UnassignedInfo.getNumberOfDelayedUnassigned(clusterState), pendingTaskTimeInQueue);
            response.setStatus(ClusterHealthStatus.RED);
            return response;
        }
        return new ClusterHealthResponse(clusterState.getClusterName().value(), concreteIndices, clusterState, numberOfPendingTasks, numberOfInFlightFetch, UnassignedInfo.getNumberOfDelayedUnassigned(clusterState), pendingTaskTimeInQueue);
    }

    private static enum TimeoutState {
        OK,
        TIMED_OUT,
        ZERO_TIMEOUT;

    }
}

