/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.remotestore.stats;

import java.io.IOException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.remote.RemoteRefreshSegmentTracker;

public class RemoteStoreStats
implements Writeable,
ToXContentFragment {
    private final RemoteRefreshSegmentTracker.Stats remoteSegmentUploadShardStats;

    public RemoteStoreStats(RemoteRefreshSegmentTracker.Stats remoteSegmentUploadShardStats) {
        this.remoteSegmentUploadShardStats = remoteSegmentUploadShardStats;
    }

    public RemoteStoreStats(StreamInput in) throws IOException {
        this.remoteSegmentUploadShardStats = (RemoteRefreshSegmentTracker.Stats)in.readOptionalWriteable(RemoteRefreshSegmentTracker.Stats::new);
    }

    public RemoteRefreshSegmentTracker.Stats getStats() {
        return this.remoteSegmentUploadShardStats;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("shard_id", (ToXContent)this.remoteSegmentUploadShardStats.shardId).field("local_refresh_timestamp_in_millis", this.remoteSegmentUploadShardStats.localRefreshClockTimeMs).field("remote_refresh_timestamp_in_millis", this.remoteSegmentUploadShardStats.remoteRefreshClockTimeMs).field("refresh_time_lag_in_millis", this.remoteSegmentUploadShardStats.refreshTimeLagMs).field("refresh_lag", this.remoteSegmentUploadShardStats.localRefreshNumber - this.remoteSegmentUploadShardStats.remoteRefreshNumber).field("bytes_lag", this.remoteSegmentUploadShardStats.bytesLag).field("backpressure_rejection_count", this.remoteSegmentUploadShardStats.rejectionCount).field("consecutive_failure_count", this.remoteSegmentUploadShardStats.consecutiveFailuresCount);
        builder.startObject("total_remote_refresh");
        builder.field("started", this.remoteSegmentUploadShardStats.totalUploadsStarted).field("succeeded", this.remoteSegmentUploadShardStats.totalUploadsSucceeded).field("failed", this.remoteSegmentUploadShardStats.totalUploadsFailed);
        builder.endObject();
        builder.startObject("total_uploads_in_bytes");
        builder.field("started", this.remoteSegmentUploadShardStats.uploadBytesStarted).field("succeeded", this.remoteSegmentUploadShardStats.uploadBytesSucceeded).field("failed", this.remoteSegmentUploadShardStats.uploadBytesFailed);
        builder.endObject();
        builder.startObject("remote_refresh_size_in_bytes");
        builder.field("last_successful", this.remoteSegmentUploadShardStats.lastSuccessfulRemoteRefreshBytes);
        builder.field("moving_avg", this.remoteSegmentUploadShardStats.uploadBytesMovingAverage);
        builder.endObject();
        builder.startObject("upload_latency_in_bytes_per_sec");
        builder.field("moving_avg", this.remoteSegmentUploadShardStats.uploadBytesPerSecMovingAverage);
        builder.endObject();
        builder.startObject("remote_refresh_latency_in_millis");
        builder.field("moving_avg", this.remoteSegmentUploadShardStats.uploadTimeMovingAverage);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.remoteSegmentUploadShardStats);
    }

    static final class SubFields {
        static final String STARTED = "started";
        static final String SUCCEEDED = "succeeded";
        static final String FAILED = "failed";
        static final String MOVING_AVG = "moving_avg";
        static final String LAST_SUCCESSFUL = "last_successful";

        SubFields() {
        }
    }

    static final class Fields {
        static final String SHARD_ID = "shard_id";
        static final String BYTES_LAG = "bytes_lag";
        static final String REFRESH_LAG = "refresh_lag";
        static final String REFRESH_TIME_LAG_IN_MILLIS = "refresh_time_lag_in_millis";
        static final String LOCAL_REFRESH_TIMESTAMP = "local_refresh_timestamp_in_millis";
        static final String REMOTE_REFRESH_TIMESTAMP = "remote_refresh_timestamp_in_millis";
        static final String BACKPRESSURE_REJECTION_COUNT = "backpressure_rejection_count";
        static final String CONSECUTIVE_FAILURE_COUNT = "consecutive_failure_count";
        static final String TOTAL_REMOTE_REFRESH = "total_remote_refresh";
        static final String TOTAL_UPLOADS_IN_BYTES = "total_uploads_in_bytes";
        static final String REMOTE_REFRESH_SIZE_IN_BYTES = "remote_refresh_size_in_bytes";
        static final String UPLOAD_LATENCY_IN_BYTES_PER_SEC = "upload_latency_in_bytes_per_sec";
        static final String REMOTE_REFRESH_LATENCY_IN_MILLIS = "remote_refresh_latency_in_millis";

        Fields() {
        }
    }
}

