/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.repositories.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.RepositoriesMetadata;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.regex.Regex;
import org.opensearch.repositories.RepositoryMissingException;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportGetRepositoriesAction
extends TransportClusterManagerNodeReadAction<GetRepositoriesRequest, GetRepositoriesResponse> {
    @Inject
    public TransportGetRepositoriesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/repository/get", transportService, clusterService, threadPool, actionFilters, GetRepositoriesRequest::new, indexNameExpressionResolver);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected GetRepositoriesResponse read(StreamInput in) throws IOException {
        return new GetRepositoriesResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(GetRepositoriesRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void clusterManagerOperation(GetRepositoriesRequest request, ClusterState state, ActionListener<GetRepositoriesResponse> listener) {
        Metadata metadata = state.metadata();
        RepositoriesMetadata repositories = (RepositoriesMetadata)metadata.custom("repositories");
        if (request.repositories().length == 0 || request.repositories().length == 1 && "_all".equals(request.repositories()[0])) {
            if (repositories != null) {
                listener.onResponse(new GetRepositoriesResponse(repositories));
            } else {
                listener.onResponse(new GetRepositoriesResponse(new RepositoriesMetadata(Collections.emptyList())));
            }
        } else if (repositories != null) {
            LinkedHashSet<String> repositoriesToGet = new LinkedHashSet<String>();
            for (String repositoryOrPattern : request.repositories()) {
                if (!Regex.isSimpleMatchPattern(repositoryOrPattern)) {
                    repositoriesToGet.add(repositoryOrPattern);
                    continue;
                }
                for (RepositoryMetadata repository : repositories.repositories()) {
                    if (!Regex.simpleMatch(repositoryOrPattern, repository.name())) continue;
                    repositoriesToGet.add(repository.name());
                }
            }
            ArrayList<RepositoryMetadata> repositoryListBuilder = new ArrayList<RepositoryMetadata>();
            for (String repository : repositoriesToGet) {
                RepositoryMetadata repositoryMetadata = repositories.repository(repository);
                if (repositoryMetadata == null) {
                    listener.onFailure((Exception)((Object)new RepositoryMissingException(repository)));
                    return;
                }
                repositoryListBuilder.add(repositoryMetadata);
            }
            listener.onResponse(new GetRepositoriesResponse(new RepositoriesMetadata(repositoryListBuilder)));
        } else {
            listener.onFailure((Exception)((Object)new RepositoryMissingException(request.repositories()[0])));
        }
    }
}

