/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.shards.routing.weighted.put;

import java.io.IOException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.admin.cluster.shards.routing.weighted.put.ClusterPutWeightedRoutingRequest;
import org.opensearch.action.admin.cluster.shards.routing.weighted.put.ClusterPutWeightedRoutingResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.WeightedRoutingService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportAddWeightedRoutingAction
extends TransportClusterManagerNodeAction<ClusterPutWeightedRoutingRequest, ClusterPutWeightedRoutingResponse> {
    private final WeightedRoutingService weightedRoutingService;

    @Inject
    public TransportAddWeightedRoutingAction(TransportService transportService, ClusterService clusterService, WeightedRoutingService weightedRoutingService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/routing/awareness/weights/put", transportService, clusterService, threadPool, actionFilters, ClusterPutWeightedRoutingRequest::new, indexNameExpressionResolver);
        this.weightedRoutingService = weightedRoutingService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterPutWeightedRoutingResponse read(StreamInput in) throws IOException {
        return new ClusterPutWeightedRoutingResponse(in);
    }

    @Override
    protected void clusterManagerOperation(ClusterPutWeightedRoutingRequest request, ClusterState state, ActionListener<ClusterPutWeightedRoutingResponse> listener) throws Exception {
        try {
            this.weightedRoutingService.verifyAwarenessAttribute(request.getWeightedRouting().attributeName());
        }
        catch (ActionRequestValidationException ex) {
            listener.onFailure((Exception)((Object)ex));
            return;
        }
        this.weightedRoutingService.registerWeightedRoutingMetadata(request, ActionListener.delegateFailure(listener, (delegatedListener, response) -> delegatedListener.onResponse(new ClusterPutWeightedRoutingResponse(response.isAcknowledged()))));
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterPutWeightedRoutingRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

