/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.action.admin.cluster.stats.IndexFeatureStats;
import org.opensearch.action.admin.cluster.stats.MappingVisitor;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public final class AnalysisStats
implements ToXContentFragment,
Writeable {
    private final Set<IndexFeatureStats> usedCharFilters;
    private final Set<IndexFeatureStats> usedTokenizers;
    private final Set<IndexFeatureStats> usedTokenFilters;
    private final Set<IndexFeatureStats> usedAnalyzers;
    private final Set<IndexFeatureStats> usedBuiltInCharFilters;
    private final Set<IndexFeatureStats> usedBuiltInTokenizers;
    private final Set<IndexFeatureStats> usedBuiltInTokenFilters;
    private final Set<IndexFeatureStats> usedBuiltInAnalyzers;

    public static AnalysisStats of(ClusterState state) {
        HashMap<String, IndexFeatureStats> usedCharFilterTypes = new HashMap<String, IndexFeatureStats>();
        HashMap<String, IndexFeatureStats> usedTokenizerTypes = new HashMap<String, IndexFeatureStats>();
        HashMap<String, IndexFeatureStats> usedTokenFilterTypes = new HashMap<String, IndexFeatureStats>();
        HashMap<String, IndexFeatureStats> usedAnalyzerTypes = new HashMap<String, IndexFeatureStats>();
        HashMap<String, IndexFeatureStats> usedBuiltInCharFilters = new HashMap<String, IndexFeatureStats>();
        HashMap<String, IndexFeatureStats> usedBuiltInTokenizers = new HashMap<String, IndexFeatureStats>();
        HashMap<String, IndexFeatureStats> usedBuiltInTokenFilters = new HashMap<String, IndexFeatureStats>();
        HashMap usedBuiltInAnalyzers = new HashMap();
        for (IndexMetadata indexMetadata : state.metadata()) {
            HashSet indexAnalyzers = new HashSet();
            MappingMetadata mappingMetadata = indexMetadata.mapping();
            if (mappingMetadata != null) {
                MappingVisitor.visitMapping(mappingMetadata.getSourceAsMap(), fieldMapping -> {
                    for (String key : new String[]{"analyzer", "search_analyzer", "search_quote_analyzer"}) {
                        Object analyzerO = fieldMapping.get(key);
                        if (analyzerO == null) continue;
                        String analyzer = analyzerO.toString();
                        IndexFeatureStats stats = usedBuiltInAnalyzers.computeIfAbsent(analyzer, IndexFeatureStats::new);
                        ++stats.count;
                        if (!indexAnalyzers.add(analyzer)) continue;
                        ++stats.indexCount;
                    }
                });
            }
            HashSet<String> indexCharFilters = new HashSet<String>();
            HashSet<String> indexTokenizers = new HashSet<String>();
            HashSet<String> indexTokenFilters = new HashSet<String>();
            HashSet<String> indexAnalyzerTypes = new HashSet<String>();
            HashSet<String> indexCharFilterTypes = new HashSet<String>();
            HashSet<String> indexTokenizerTypes = new HashSet<String>();
            HashSet<String> indexTokenFilterTypes = new HashSet<String>();
            Settings indexSettings = indexMetadata.getSettings();
            Map<String, Settings> analyzerSettings = indexSettings.getGroups("index.analysis.analyzer");
            usedBuiltInAnalyzers.keySet().removeAll(analyzerSettings.keySet());
            for (Settings analyzerSetting : analyzerSettings.values()) {
                String analyzerType = analyzerSetting.get("type", "custom");
                IndexFeatureStats stats = usedAnalyzerTypes.computeIfAbsent(analyzerType, IndexFeatureStats::new);
                ++stats.count;
                if (indexAnalyzerTypes.add(analyzerType)) {
                    ++stats.indexCount;
                }
                for (String charFilter : analyzerSetting.getAsList("char_filter")) {
                    stats = usedBuiltInCharFilters.computeIfAbsent(charFilter, IndexFeatureStats::new);
                    ++stats.count;
                    if (!indexCharFilters.add(charFilter)) continue;
                    ++stats.indexCount;
                }
                String tokenizer = analyzerSetting.get("tokenizer");
                if (tokenizer != null) {
                    stats = usedBuiltInTokenizers.computeIfAbsent(tokenizer, IndexFeatureStats::new);
                    ++stats.count;
                    if (indexTokenizers.add(tokenizer)) {
                        ++stats.indexCount;
                    }
                }
                for (String filter : analyzerSetting.getAsList("filter")) {
                    stats = usedBuiltInTokenFilters.computeIfAbsent(filter, IndexFeatureStats::new);
                    ++stats.count;
                    if (!indexTokenFilters.add(filter)) continue;
                    ++stats.indexCount;
                }
            }
            Map<String, Settings> charFilterSettings = indexSettings.getGroups("index.analysis.char_filter");
            usedBuiltInCharFilters.keySet().removeAll(charFilterSettings.keySet());
            AnalysisStats.aggregateAnalysisTypes(charFilterSettings.values(), usedCharFilterTypes, indexCharFilterTypes);
            Map<String, Settings> tokenizerSettings = indexSettings.getGroups("index.analysis.tokenizer");
            usedBuiltInTokenizers.keySet().removeAll(tokenizerSettings.keySet());
            AnalysisStats.aggregateAnalysisTypes(tokenizerSettings.values(), usedTokenizerTypes, indexTokenizerTypes);
            Map<String, Settings> tokenFilterSettings = indexSettings.getGroups("index.analysis.filter");
            usedBuiltInTokenFilters.keySet().removeAll(tokenFilterSettings.keySet());
            AnalysisStats.aggregateAnalysisTypes(tokenFilterSettings.values(), usedTokenFilterTypes, indexTokenFilterTypes);
        }
        return new AnalysisStats(usedCharFilterTypes.values(), usedTokenizerTypes.values(), usedTokenFilterTypes.values(), usedAnalyzerTypes.values(), usedBuiltInCharFilters.values(), usedBuiltInTokenizers.values(), usedBuiltInTokenFilters.values(), usedBuiltInAnalyzers.values());
    }

    private static void aggregateAnalysisTypes(Collection<Settings> settings, Map<String, IndexFeatureStats> stats, Set<String> indexTypes) {
        for (Settings analysisComponentSettings : settings) {
            String type = analysisComponentSettings.get("type");
            if (type == null) continue;
            IndexFeatureStats s = stats.computeIfAbsent(type, IndexFeatureStats::new);
            ++s.count;
            if (!indexTypes.add(type)) continue;
            ++s.indexCount;
        }
    }

    private static Set<IndexFeatureStats> sort(Collection<IndexFeatureStats> set) {
        ArrayList<IndexFeatureStats> list = new ArrayList<IndexFeatureStats>(set);
        list.sort(Comparator.comparing(IndexFeatureStats::getName));
        return Collections.unmodifiableSet(new LinkedHashSet<IndexFeatureStats>(list));
    }

    AnalysisStats(Collection<IndexFeatureStats> usedCharFilters, Collection<IndexFeatureStats> usedTokenizers, Collection<IndexFeatureStats> usedTokenFilters, Collection<IndexFeatureStats> usedAnalyzers, Collection<IndexFeatureStats> usedBuiltInCharFilters, Collection<IndexFeatureStats> usedBuiltInTokenizers, Collection<IndexFeatureStats> usedBuiltInTokenFilters, Collection<IndexFeatureStats> usedBuiltInAnalyzers) {
        this.usedCharFilters = AnalysisStats.sort(usedCharFilters);
        this.usedTokenizers = AnalysisStats.sort(usedTokenizers);
        this.usedTokenFilters = AnalysisStats.sort(usedTokenFilters);
        this.usedAnalyzers = AnalysisStats.sort(usedAnalyzers);
        this.usedBuiltInCharFilters = AnalysisStats.sort(usedBuiltInCharFilters);
        this.usedBuiltInTokenizers = AnalysisStats.sort(usedBuiltInTokenizers);
        this.usedBuiltInTokenFilters = AnalysisStats.sort(usedBuiltInTokenFilters);
        this.usedBuiltInAnalyzers = AnalysisStats.sort(usedBuiltInAnalyzers);
    }

    public AnalysisStats(StreamInput input) throws IOException {
        this.usedCharFilters = Collections.unmodifiableSet(new LinkedHashSet(input.readList(IndexFeatureStats::new)));
        this.usedTokenizers = Collections.unmodifiableSet(new LinkedHashSet(input.readList(IndexFeatureStats::new)));
        this.usedTokenFilters = Collections.unmodifiableSet(new LinkedHashSet(input.readList(IndexFeatureStats::new)));
        this.usedAnalyzers = Collections.unmodifiableSet(new LinkedHashSet(input.readList(IndexFeatureStats::new)));
        this.usedBuiltInCharFilters = Collections.unmodifiableSet(new LinkedHashSet(input.readList(IndexFeatureStats::new)));
        this.usedBuiltInTokenizers = Collections.unmodifiableSet(new LinkedHashSet(input.readList(IndexFeatureStats::new)));
        this.usedBuiltInTokenFilters = Collections.unmodifiableSet(new LinkedHashSet(input.readList(IndexFeatureStats::new)));
        this.usedBuiltInAnalyzers = Collections.unmodifiableSet(new LinkedHashSet(input.readList(IndexFeatureStats::new)));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.usedCharFilters);
        out.writeCollection(this.usedTokenizers);
        out.writeCollection(this.usedTokenFilters);
        out.writeCollection(this.usedAnalyzers);
        out.writeCollection(this.usedBuiltInCharFilters);
        out.writeCollection(this.usedBuiltInTokenizers);
        out.writeCollection(this.usedBuiltInTokenFilters);
        out.writeCollection(this.usedBuiltInAnalyzers);
    }

    public Set<IndexFeatureStats> getUsedCharFilterTypes() {
        return this.usedCharFilters;
    }

    public Set<IndexFeatureStats> getUsedTokenizerTypes() {
        return this.usedTokenizers;
    }

    public Set<IndexFeatureStats> getUsedTokenFilterTypes() {
        return this.usedTokenFilters;
    }

    public Set<IndexFeatureStats> getUsedAnalyzerTypes() {
        return this.usedAnalyzers;
    }

    public Set<IndexFeatureStats> getUsedBuiltInCharFilters() {
        return this.usedBuiltInCharFilters;
    }

    public Set<IndexFeatureStats> getUsedBuiltInTokenizers() {
        return this.usedBuiltInTokenizers;
    }

    public Set<IndexFeatureStats> getUsedBuiltInTokenFilters() {
        return this.usedBuiltInTokenFilters;
    }

    public Set<IndexFeatureStats> getUsedBuiltInAnalyzers() {
        return this.usedBuiltInAnalyzers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalysisStats that = (AnalysisStats)o;
        return Objects.equals(this.usedCharFilters, that.usedCharFilters) && Objects.equals(this.usedTokenizers, that.usedTokenizers) && Objects.equals(this.usedTokenFilters, that.usedTokenFilters) && Objects.equals(this.usedAnalyzers, that.usedAnalyzers) && Objects.equals(this.usedBuiltInCharFilters, that.usedBuiltInCharFilters) && Objects.equals(this.usedBuiltInTokenizers, that.usedBuiltInTokenizers) && Objects.equals(this.usedBuiltInTokenFilters, that.usedBuiltInTokenFilters) && Objects.equals(this.usedBuiltInAnalyzers, that.usedBuiltInAnalyzers);
    }

    public int hashCode() {
        return Objects.hash(this.usedCharFilters, this.usedTokenizers, this.usedTokenFilters, this.usedAnalyzers, this.usedBuiltInCharFilters, this.usedBuiltInTokenizers, this.usedBuiltInTokenFilters, this.usedBuiltInAnalyzers);
    }

    private void toXContentCollection(XContentBuilder builder, ToXContent.Params params, String name, Collection<? extends ToXContent> coll) throws IOException {
        builder.startArray(name);
        for (ToXContent toXContent : coll) {
            toXContent.toXContent(builder, params);
        }
        builder.endArray();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("analysis");
        this.toXContentCollection(builder, params, "char_filter_types", this.usedCharFilters);
        this.toXContentCollection(builder, params, "tokenizer_types", this.usedTokenizers);
        this.toXContentCollection(builder, params, "filter_types", this.usedTokenFilters);
        this.toXContentCollection(builder, params, "analyzer_types", this.usedAnalyzers);
        this.toXContentCollection(builder, params, "built_in_char_filters", this.usedBuiltInCharFilters);
        this.toXContentCollection(builder, params, "built_in_tokenizers", this.usedBuiltInTokenizers);
        this.toXContentCollection(builder, params, "built_in_filters", this.usedBuiltInTokenFilters);
        this.toXContentCollection(builder, params, "built_in_analyzers", this.usedBuiltInAnalyzers);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((MediaType)XContentType.JSON, (ToXContent)this, true, true);
    }
}

