/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.datastream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.ActionType;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeReadRequest;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.health.ClusterStateHealth;
import org.opensearch.cluster.metadata.DataStream;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.Index;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class GetDataStreamAction
extends ActionType<Response> {
    public static final GetDataStreamAction INSTANCE = new GetDataStreamAction();
    public static final String NAME = "indices:admin/data_stream/get";

    private GetDataStreamAction() {
        super(NAME, Response::new);
    }

    public static class TransportAction
    extends TransportClusterManagerNodeReadAction<Request, Response> {
        private static final Logger logger = LogManager.getLogger(TransportAction.class);

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(GetDataStreamAction.NAME, transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver);
        }

        @Override
        protected String executor() {
            return "same";
        }

        @Override
        protected Response read(StreamInput in) throws IOException {
            return new Response(in);
        }

        @Override
        protected void clusterManagerOperation(Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
            List<DataStream> dataStreams = TransportAction.getDataStreams(state, this.indexNameExpressionResolver, request);
            ArrayList<Response.DataStreamInfo> dataStreamInfos = new ArrayList<Response.DataStreamInfo>(dataStreams.size());
            for (DataStream dataStream : dataStreams) {
                String indexTemplate = MetadataIndexTemplateService.findV2Template(state.metadata(), dataStream.getName(), false);
                String ilmPolicyName = null;
                if (indexTemplate != null) {
                    Settings settings = MetadataIndexTemplateService.resolveSettings(state.metadata(), indexTemplate);
                    ilmPolicyName = settings.get("index.lifecycle.name");
                } else {
                    logger.warn("couldn't find any matching template for data stream [{}]. has it been restored (and possibly renamed)from a snapshot?", (Object)dataStream.getName());
                }
                ClusterStateHealth streamHealth = new ClusterStateHealth(state, (String[])dataStream.getIndices().stream().map(Index::getName).toArray(String[]::new));
                dataStreamInfos.add(new Response.DataStreamInfo(dataStream, streamHealth.getStatus(), indexTemplate));
            }
            listener.onResponse(new Response(dataStreamInfos));
        }

        static List<DataStream> getDataStreams(ClusterState clusterState, IndexNameExpressionResolver iner, Request request) {
            List<String> results = iner.dataStreamNames(clusterState, request.indicesOptions(), request.names);
            Map<String, DataStream> dataStreams = clusterState.metadata().dataStreams();
            return results.stream().map(dataStreams::get).sorted(Comparator.comparing(DataStream::getName)).collect(Collectors.toList());
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField DATASTREAMS_FIELD = new ParseField("data_streams", new String[0]);
        private final List<DataStreamInfo> dataStreams;

        public Response(List<DataStreamInfo> dataStreams) {
            this.dataStreams = dataStreams;
        }

        public Response(StreamInput in) throws IOException {
            this(in.readList(DataStreamInfo::new));
        }

        public List<DataStreamInfo> getDataStreams() {
            return this.dataStreams;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.dataStreams);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray(DATASTREAMS_FIELD.getPreferredName());
            for (DataStreamInfo dataStream : this.dataStreams) {
                dataStream.toXContent(builder, params);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.dataStreams.equals(response.dataStreams);
        }

        public int hashCode() {
            return Objects.hash(this.dataStreams);
        }

        public static class DataStreamInfo
        extends AbstractDiffable<DataStreamInfo>
        implements ToXContentObject {
            public static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
            public static final ParseField INDEX_TEMPLATE_FIELD = new ParseField("template", new String[0]);
            DataStream dataStream;
            ClusterHealthStatus dataStreamStatus;
            @Nullable
            String indexTemplate;

            public DataStreamInfo(DataStream dataStream, ClusterHealthStatus dataStreamStatus, @Nullable String indexTemplate) {
                this.dataStream = dataStream;
                this.dataStreamStatus = dataStreamStatus;
                this.indexTemplate = indexTemplate;
            }

            public DataStreamInfo(StreamInput in) throws IOException {
                this(new DataStream(in), ClusterHealthStatus.readFrom(in), in.readOptionalString());
            }

            public DataStream getDataStream() {
                return this.dataStream;
            }

            public ClusterHealthStatus getDataStreamStatus() {
                return this.dataStreamStatus;
            }

            @Nullable
            public String getIndexTemplate() {
                return this.indexTemplate;
            }

            public void writeTo(StreamOutput out) throws IOException {
                this.dataStream.writeTo(out);
                this.dataStreamStatus.writeTo(out);
                out.writeOptionalString(this.indexTemplate);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(DataStream.NAME_FIELD.getPreferredName(), this.dataStream.getName());
                builder.field(DataStream.TIMESTAMP_FIELD_FIELD.getPreferredName(), (ToXContent)this.dataStream.getTimeStampField());
                builder.field(DataStream.INDICES_FIELD.getPreferredName(), this.dataStream.getIndices());
                builder.field(DataStream.GENERATION_FIELD.getPreferredName(), this.dataStream.getGeneration());
                builder.field(STATUS_FIELD.getPreferredName(), (Object)this.dataStreamStatus);
                if (this.indexTemplate != null) {
                    builder.field(INDEX_TEMPLATE_FIELD.getPreferredName(), this.indexTemplate);
                }
                builder.endObject();
                return builder;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DataStreamInfo that = (DataStreamInfo)o;
                return this.dataStream.equals(that.dataStream) && this.dataStreamStatus == that.dataStreamStatus && Objects.equals(this.indexTemplate, that.indexTemplate);
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.dataStream, this.dataStreamStatus, this.indexTemplate});
            }
        }
    }

    public static class Request
    extends ClusterManagerNodeReadRequest<Request>
    implements IndicesRequest.Replaceable {
        private String[] names;

        public Request(String[] names) {
            this.names = names;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readOptionalStringArray();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalStringArray(this.names);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.names, request.names);
        }

        public int hashCode() {
            return Arrays.hashCode(this.names);
        }

        @Override
        public String[] indices() {
            return this.names;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.fromOptions(false, true, true, true, false, false, true, false);
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        @Override
        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }
    }
}

