/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.shrink;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.shrink.ResizeType;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.AcknowledgedRequest;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ResizeRequest
extends AcknowledgedRequest<ResizeRequest>
implements IndicesRequest,
ToXContentObject {
    public static final ObjectParser<ResizeRequest, Void> PARSER = new ObjectParser("resize_request");
    private static final ParseField MAX_SHARD_SIZE = new ParseField("max_shard_size", new String[0]);
    private CreateIndexRequest targetIndexRequest;
    private String sourceIndex;
    private ResizeType type = ResizeType.SHRINK;
    private Boolean copySettings = true;
    private ByteSizeValue maxShardSize;
    private boolean shouldStoreResult;

    public ResizeRequest(StreamInput in) throws IOException {
        super(in);
        this.targetIndexRequest = new CreateIndexRequest(in);
        this.sourceIndex = in.readString();
        this.type = (ResizeType)in.readEnum(ResizeType.class);
        this.copySettings = in.readOptionalBoolean();
        if (in.getVersion().onOrAfter(Version.V_2_5_0)) {
            this.maxShardSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
        }
    }

    ResizeRequest() {
    }

    public ResizeRequest(String targetIndex, String sourceIndex) {
        this.targetIndexRequest = new CreateIndexRequest(targetIndex);
        this.sourceIndex = sourceIndex;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException;
        ActionRequestValidationException actionRequestValidationException = validationException = this.targetIndexRequest == null ? null : this.targetIndexRequest.validate();
        if (this.sourceIndex == null) {
            validationException = ValidateActions.addValidationError("source index is missing", validationException);
        }
        if (this.targetIndexRequest == null) {
            validationException = ValidateActions.addValidationError("target index request is missing", validationException);
        }
        if (!this.targetIndexRequest.settings().getByPrefix("index.sort.").isEmpty()) {
            validationException = ValidateActions.addValidationError("can't override index sort when resizing an index", validationException);
        }
        if (IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING.exists(this.targetIndexRequest.settings())) {
            validationException = ValidateActions.addValidationError("cannot provide a routing partition size value when resizing an index", validationException);
        }
        if (this.type == ResizeType.SPLIT && !IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(this.targetIndexRequest.settings())) {
            validationException = ValidateActions.addValidationError("index.number_of_shards is required for split operations", validationException);
        }
        if (this.type != ResizeType.SHRINK && this.maxShardSize != null) {
            validationException = ValidateActions.addValidationError("Unsupported parameter [max_shard_size]", validationException);
        }
        if (this.type == ResizeType.SHRINK && IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(this.targetIndexRequest.settings()) && this.maxShardSize != null) {
            validationException = ValidateActions.addValidationError("Cannot set max_shard_size and index.number_of_shards at the same time!", validationException);
        }
        if (this.maxShardSize != null && this.maxShardSize.getBytes() <= 0L) {
            validationException = ValidateActions.addValidationError("max_shard_size must be greater than 0", validationException);
        }
        if (IndexMetadata.INDEX_READ_ONLY_SETTING.get(this.targetIndexRequest.settings()).booleanValue()) {
            validationException = ValidateActions.addValidationError("target index [" + this.targetIndexRequest.index() + "] will be blocked by [index.blocks.read_only=true], this will disable metadata writes and cause the shards to be unassigned", validationException);
        }
        if (IndexMetadata.INDEX_BLOCKS_METADATA_SETTING.get(this.targetIndexRequest.settings()).booleanValue()) {
            validationException = ValidateActions.addValidationError("target index [" + this.targetIndexRequest.index() + "] will be blocked by [index.blocks.metadata=true], this will disable metadata writes and cause the shards to be unassigned", validationException);
        }
        assert (this.copySettings == null || this.copySettings.booleanValue());
        return validationException;
    }

    public void setSourceIndex(String index) {
        this.sourceIndex = index;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.targetIndexRequest.writeTo(out);
        out.writeString(this.sourceIndex);
        if (this.type == ResizeType.CLONE && out.getVersion().before((Version)LegacyESVersion.V_7_4_0)) {
            throw new IllegalArgumentException("can't send clone request to a node that's older than " + LegacyESVersion.V_7_4_0);
        }
        out.writeEnum((Enum)this.type);
        out.writeOptionalBoolean(this.copySettings);
        if (out.getVersion().onOrAfter(Version.V_2_5_0)) {
            out.writeOptionalWriteable((Writeable)this.maxShardSize);
        }
    }

    @Override
    public String[] indices() {
        return new String[]{this.sourceIndex};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.lenientExpandOpen();
    }

    public void setTargetIndex(CreateIndexRequest targetIndexRequest) {
        this.targetIndexRequest = Objects.requireNonNull(targetIndexRequest, "target index request must not be null");
    }

    public CreateIndexRequest getTargetIndexRequest() {
        return this.targetIndexRequest;
    }

    public String getSourceIndex() {
        return this.sourceIndex;
    }

    public void setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.getTargetIndexRequest().waitForActiveShards(waitForActiveShards);
    }

    public void setWaitForActiveShards(int waitForActiveShards) {
        this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public void setResizeType(ResizeType type) {
        this.type = Objects.requireNonNull(type);
    }

    public ResizeType getResizeType() {
        return this.type;
    }

    public void setCopySettings(Boolean copySettings) {
        if (copySettings != null && !copySettings.booleanValue()) {
            throw new IllegalArgumentException("[copySettings] can not be explicitly set to [false]");
        }
        this.copySettings = copySettings;
    }

    public Boolean getCopySettings() {
        return this.copySettings;
    }

    public void setMaxShardSize(ByteSizeValue maxShardSize) {
        this.maxShardSize = maxShardSize;
    }

    public ByteSizeValue getMaxShardSize() {
        return this.maxShardSize;
    }

    public void setShouldStoreResult(boolean shouldStoreResult) {
        this.shouldStoreResult = shouldStoreResult;
    }

    @Override
    public boolean getShouldStoreResult() {
        return this.shouldStoreResult;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(CreateIndexRequest.SETTINGS.getPreferredName());
        this.targetIndexRequest.settings().toXContent(builder, params);
        builder.endObject();
        builder.startObject(CreateIndexRequest.ALIASES.getPreferredName());
        for (Alias alias : this.targetIndexRequest.aliases()) {
            alias.toXContent(builder, params);
        }
        builder.endObject();
        if (this.maxShardSize != null) {
            builder.field(MAX_SHARD_SIZE.getPreferredName(), (ToXContent)this.maxShardSize);
        }
        builder.endObject();
        return builder;
    }

    public void fromXContent(XContentParser parser) throws IOException {
        PARSER.parse(parser, (Object)this, null);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        switch (this.getResizeType()) {
            case SPLIT: {
                b.append("split from");
                break;
            }
            case CLONE: {
                b.append("clone from");
                break;
            }
            default: {
                b.append("shrink from");
            }
        }
        b.append(" [").append(this.sourceIndex).append("]");
        b.append(" to [").append(this.getTargetIndexRequest().index()).append(']');
        return b.toString();
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    static {
        PARSER.declareField((parser, request, context) -> request.getTargetIndexRequest().settings(parser.map()), new ParseField("settings", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, context) -> request.getTargetIndexRequest().aliases(parser.map()), new ParseField("aliases", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareField(ResizeRequest::setMaxShardSize, (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), MAX_SHARD_SIZE.getPreferredName()), MAX_SHARD_SIZE, ObjectParser.ValueType.STRING);
    }
}

