/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.template.post;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.template.post.SimulateIndexTemplateResponse;
import org.opensearch.action.admin.indices.template.post.SimulateTemplateAction;
import org.opensearch.action.admin.indices.template.post.TransportSimulateIndexTemplateAction;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.AliasValidator;
import org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.opensearch.cluster.metadata.Template;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.UUIDs;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.indices.IndicesService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportSimulateTemplateAction
extends TransportClusterManagerNodeReadAction<SimulateTemplateAction.Request, SimulateIndexTemplateResponse> {
    private final MetadataIndexTemplateService indexTemplateService;
    private final NamedXContentRegistry xContentRegistry;
    private final IndicesService indicesService;
    private AliasValidator aliasValidator;

    @Inject
    public TransportSimulateTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry xContentRegistry, IndicesService indicesService) {
        super("indices:admin/index_template/simulate", transportService, clusterService, threadPool, actionFilters, SimulateTemplateAction.Request::new, indexNameExpressionResolver);
        this.indexTemplateService = indexTemplateService;
        this.xContentRegistry = xContentRegistry;
        this.indicesService = indicesService;
        this.aliasValidator = new AliasValidator();
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected SimulateIndexTemplateResponse read(StreamInput in) throws IOException {
        return new SimulateIndexTemplateResponse(in);
    }

    @Override
    protected void clusterManagerOperation(SimulateTemplateAction.Request request, ClusterState state, ActionListener<SimulateIndexTemplateResponse> listener) throws Exception {
        ClusterState stateWithTemplate;
        Object simulateTemplateToAdd;
        String uuid = UUIDs.randomBase64UUID().toLowerCase(Locale.ROOT);
        String temporaryIndexName = "simulate_template_index_" + uuid;
        if (request.getIndexTemplateRequest() != null) {
            simulateTemplateToAdd = request.getTemplateName() == null ? "simulate_template_" + uuid : request.getTemplateName();
            MetadataIndexTemplateService.validateV2TemplateRequest(state.metadata(), (String)simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
            stateWithTemplate = this.indexTemplateService.addIndexTemplateV2(state, request.getIndexTemplateRequest().create(), (String)simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
        } else {
            simulateTemplateToAdd = null;
            stateWithTemplate = state;
        }
        Object matchingTemplate = request.getTemplateName() == null ? simulateTemplateToAdd : request.getTemplateName();
        if (matchingTemplate == null) {
            listener.onFailure(new IllegalArgumentException("a template name to match or a new template body must be specified"));
            return;
        }
        if (!stateWithTemplate.metadata().templatesV2().containsKey(matchingTemplate)) {
            listener.onFailure(new IllegalArgumentException("unable to simulate template [" + (String)matchingTemplate + "] that does not exist"));
            return;
        }
        ClusterState tempClusterState = TransportSimulateIndexTemplateAction.resolveTemporaryState((String)matchingTemplate, temporaryIndexName, stateWithTemplate);
        ComposableIndexTemplate templateV2 = tempClusterState.metadata().templatesV2().get(matchingTemplate);
        assert (templateV2 != null) : "the matched template must exist";
        HashMap<String, List<String>> overlapping = new HashMap<String, List<String>>();
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV1Templates(tempClusterState, (String)matchingTemplate, templateV2.indexPatterns()));
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV2Templates(tempClusterState, (String)matchingTemplate, templateV2.indexPatterns()));
        Template template = TransportSimulateIndexTemplateAction.resolveTemplate((String)matchingTemplate, temporaryIndexName, stateWithTemplate, this.xContentRegistry, this.indicesService, this.aliasValidator);
        listener.onResponse(new SimulateIndexTemplateResponse(template, overlapping));
    }

    @Override
    protected ClusterBlockException checkBlock(SimulateTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

