/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.validate.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.admin.indices.validate.query.QueryExplanation;
import org.opensearch.action.support.DefaultShardOperationFailedException;
import org.opensearch.action.support.broadcast.BroadcastResponse;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ValidateQueryResponse
extends BroadcastResponse {
    public static final String VALID_FIELD = "valid";
    public static final String EXPLANATIONS_FIELD = "explanations";
    static final ConstructingObjectParser<ValidateQueryResponse, Void> PARSER = new ConstructingObjectParser("validate_query", true, arg -> {
        BroadcastResponse response = (BroadcastResponse)arg[0];
        return new ValidateQueryResponse((Boolean)arg[1], (List)arg[2], response.getTotalShards(), response.getSuccessfulShards(), response.getFailedShards(), Arrays.asList(response.getShardFailures()));
    });
    private final boolean valid;
    private final List<QueryExplanation> queryExplanations;

    ValidateQueryResponse(StreamInput in) throws IOException {
        super(in);
        this.valid = in.readBoolean();
        this.queryExplanations = in.readList(QueryExplanation::new);
    }

    ValidateQueryResponse(boolean valid, List<QueryExplanation> queryExplanations, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.valid = valid;
        this.queryExplanations = queryExplanations == null ? Collections.emptyList() : queryExplanations;
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<? extends QueryExplanation> getQueryExplanation() {
        return this.queryExplanations;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.valid);
        out.writeCollection(this.queryExplanations);
    }

    @Override
    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(VALID_FIELD, this.isValid());
        if (this.getQueryExplanation() != null && !this.getQueryExplanation().isEmpty()) {
            builder.startArray(EXPLANATIONS_FIELD);
            for (QueryExplanation queryExplanation : this.getQueryExplanation()) {
                builder.startObject();
                queryExplanation.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
    }

    public static ValidateQueryResponse fromXContent(XContentParser parser) {
        return (ValidateQueryResponse)PARSER.apply(parser, null);
    }

    static {
        ValidateQueryResponse.declareBroadcastFields(PARSER);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField(VALID_FIELD, new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), QueryExplanation.PARSER, new ParseField(EXPLANATIONS_FIELD, new String[0]));
    }
}

