/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.action.ActionResponse;
import org.opensearch.common.Strings;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.StatusToXContentObject;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.pipeline.PipelineConfiguration;

public class GetSearchPipelineResponse
extends ActionResponse
implements StatusToXContentObject {
    private final List<PipelineConfiguration> pipelines;

    public GetSearchPipelineResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.pipelines = new ArrayList<PipelineConfiguration>(size);
        for (int i = 0; i < size; ++i) {
            this.pipelines.add(PipelineConfiguration.readFrom(in));
        }
    }

    public GetSearchPipelineResponse(List<PipelineConfiguration> pipelines) {
        this.pipelines = pipelines;
    }

    public List<PipelineConfiguration> pipelines() {
        return Collections.unmodifiableList(this.pipelines);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (PipelineConfiguration pipeline : this.pipelines) {
            builder.field(pipeline.getId(), pipeline.getConfigAsMap());
        }
        builder.endObject();
        return builder;
    }

    public static GetSearchPipelineResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        ArrayList<PipelineConfiguration> pipelines = new ArrayList<PipelineConfiguration>();
        while (parser.nextToken().equals((Object)XContentParser.Token.FIELD_NAME)) {
            String pipelineId = parser.currentName();
            parser.nextToken();
            XContentBuilder contentBuilder = XContentBuilder.builder((XContent)parser.contentType().xContent());
            try {
                contentBuilder.generator().copyCurrentStructure(parser);
                PipelineConfiguration pipeline = new PipelineConfiguration(pipelineId, BytesReference.bytes((XContentBuilder)contentBuilder), contentBuilder.contentType());
                pipelines.add(pipeline);
            }
            finally {
                if (contentBuilder == null) continue;
                contentBuilder.close();
            }
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        return new GetSearchPipelineResponse(pipelines);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.pipelines.size());
        for (PipelineConfiguration pipeline : this.pipelines) {
            pipeline.writeTo(out);
        }
    }

    public boolean isFound() {
        return !this.pipelines.isEmpty();
    }

    @Override
    public RestStatus status() {
        return this.isFound() ? RestStatus.OK : RestStatus.NOT_FOUND;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSearchPipelineResponse otherResponse = (GetSearchPipelineResponse)o;
        if (this.pipelines == null) {
            return otherResponse.pipelines == null;
        }
        if (otherResponse.pipelines == null) {
            return false;
        }
        return GetSearchPipelineResponse.toMap(this.pipelines).equals(GetSearchPipelineResponse.toMap(otherResponse.pipelines));
    }

    private static Map<String, PipelineConfiguration> toMap(List<PipelineConfiguration> pipelines) {
        return pipelines.stream().collect(Collectors.toMap(PipelineConfiguration::getId, p -> p));
    }

    public String toString() {
        return Strings.toString((MediaType)XContentType.JSON, (ToXContent)this);
    }

    public int hashCode() {
        int result = 1;
        for (PipelineConfiguration pipeline : this.pipelines) {
            result += pipeline == null ? 0 : pipeline.hashCode();
        }
        return result;
    }
}

