/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.cluster.AbstractNamedDiffable;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.NamedDiff;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.repositories.RepositoryOperation;

public final class RepositoryCleanupInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final RepositoryCleanupInProgress EMPTY = new RepositoryCleanupInProgress(Collections.emptyList());
    public static final String TYPE = "repository_cleanup";
    private final List<Entry> entries;

    public RepositoryCleanupInProgress(List<Entry> entries) {
        this.entries = entries;
    }

    RepositoryCleanupInProgress(StreamInput in) throws IOException {
        this.entries = in.readList(x$0 -> new Entry(x$0));
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return RepositoryCleanupInProgress.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    public static Entry startedEntry(String repository, long repositoryStateId) {
        return new Entry(repository, repositoryStateId);
    }

    public boolean hasCleanupInProgress() {
        return !this.entries.isEmpty();
    }

    public List<Entry> entries() {
        return new ArrayList<Entry>(this.entries);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.entries);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(TYPE);
        for (Entry entry : this.entries) {
            builder.startObject();
            builder.field("repository", entry.repository);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public String toString() {
        return Strings.toString((MediaType)XContentType.JSON, (ToXContent)this);
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return LegacyESVersion.V_7_4_0;
    }

    public static final class Entry
    implements Writeable,
    RepositoryOperation {
        private final String repository;
        private final long repositoryStateId;

        private Entry(StreamInput in) throws IOException {
            this.repository = in.readString();
            this.repositoryStateId = in.readLong();
        }

        public Entry(String repository, long repositoryStateId) {
            this.repository = repository;
            this.repositoryStateId = repositoryStateId;
        }

        @Override
        public long repositoryStateId() {
            return this.repositoryStateId;
        }

        @Override
        public String repository() {
            return this.repository;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.repository);
            out.writeLong(this.repositoryStateId);
        }

        public String toString() {
            return "{" + this.repository + "}{" + this.repositoryStateId + "}";
        }
    }
}

