/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.service;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.cluster.service.ClusterManagerTaskThrottlerListener;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class ClusterManagerThrottlingStats
implements ClusterManagerTaskThrottlerListener,
Writeable,
ToXContentFragment {
    private Map<String, CounterMetric> throttledTasksCount;

    public ClusterManagerThrottlingStats() {
        this.throttledTasksCount = new ConcurrentHashMap<String, CounterMetric>();
    }

    private void incrementThrottlingCount(String type, int counts) {
        this.throttledTasksCount.computeIfAbsent(type, k -> new CounterMetric()).inc(counts);
    }

    public long getThrottlingCount(String type) {
        return this.throttledTasksCount.get(type) == null ? 0L : this.throttledTasksCount.get(type).count();
    }

    public long getTotalThrottledTaskCount() {
        CounterMetric totalCount = new CounterMetric();
        this.throttledTasksCount.forEach((aClass, counterMetric) -> totalCount.inc(counterMetric.count()));
        return totalCount.count();
    }

    @Override
    public void onThrottle(String type, int counts) {
        this.incrementThrottlingCount(type, counts);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.throttledTasksCount.size());
        for (Map.Entry<String, CounterMetric> entry : this.throttledTasksCount.entrySet()) {
            out.writeString(entry.getKey());
            out.writeVInt((int)entry.getValue().count());
        }
    }

    public ClusterManagerThrottlingStats(StreamInput in) throws IOException {
        int throttledTaskEntries = in.readVInt();
        this.throttledTasksCount = new ConcurrentHashMap<String, CounterMetric>();
        for (int i = 0; i < throttledTaskEntries; ++i) {
            String taskType = in.readString();
            int throttledTaskCount = in.readVInt();
            this.onThrottle(taskType, throttledTaskCount);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("cluster_manager_throttling");
        builder.startObject("stats");
        builder.field("total_throttled_tasks", this.getTotalThrottledTaskCount());
        builder.startObject("throttled_tasks_per_task_type");
        for (Map.Entry<String, CounterMetric> entry : this.throttledTasksCount.entrySet()) {
            builder.field(entry.getKey(), entry.getValue().count());
        }
        builder.endObject();
        builder.endObject();
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ClusterManagerThrottlingStats that = (ClusterManagerThrottlingStats)o;
            if (this.throttledTasksCount.size() == that.throttledTasksCount.size()) {
                for (Map.Entry<String, CounterMetric> entry : this.throttledTasksCount.entrySet()) {
                    if (that.throttledTasksCount.get(entry.getKey()).count() == entry.getValue().count()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        ConcurrentHashMap<String, Long> countMap = new ConcurrentHashMap<String, Long>();
        for (Map.Entry<String, CounterMetric> entry : this.throttledTasksCount.entrySet()) {
            countMap.put(entry.getKey(), entry.getValue().count());
        }
        return countMap.hashCode();
    }
}

