/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.PrimitiveIterator;
import java.util.Set;
import org.apache.lucene.util.BytesRefBuilder;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.util.CollectionUtils;
import org.opensearch.common.util.set.Sets;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class Strings {
    public static final String[] EMPTY_ARRAY = org.opensearch.core.common.Strings.EMPTY_ARRAY;
    public static final Set<Character> INVALID_FILENAME_CHARS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Character[]{Character.valueOf('\\'), Character.valueOf('/'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'), Character.valueOf(' '), Character.valueOf(',')}));

    public static boolean hasLength(BytesReference bytesReference) {
        return bytesReference != null && bytesReference.length() > 0;
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }

    public static String quote(String str) {
        return str != null ? "'" + str + "'" : null;
    }

    public static boolean validFileName(String fileName) {
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (!INVALID_FILENAME_CHARS.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean validFileNameExcludingAstrix(String fileName) {
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (c == '*' || !INVALID_FILENAME_CHARS.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static String[] split(String toSplit, String delimiter) {
        if (!org.opensearch.core.common.Strings.hasLength((String)toSplit) || !org.opensearch.core.common.Strings.hasLength((String)delimiter)) {
            return null;
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + delimiter.length());
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    public static String format1Decimals(double value, String suffix) {
        String p = String.valueOf(value);
        int ix = p.indexOf(46) + 1;
        int ex = p.indexOf(69);
        char fraction = p.charAt(ix);
        if (fraction == '0') {
            if (ex != -1) {
                return p.substring(0, ix - 1) + p.substring(ex) + suffix;
            }
            return p.substring(0, ix - 1) + suffix;
        }
        if (ex != -1) {
            return p.substring(0, ix) + fraction + p.substring(ex) + suffix;
        }
        return p.substring(0, ix) + fraction + suffix;
    }

    private Strings() {
    }

    public static byte[] toUTF8Bytes(CharSequence charSequence) {
        return Strings.toUTF8Bytes(charSequence, new BytesRefBuilder());
    }

    public static byte[] toUTF8Bytes(CharSequence charSequence, BytesRefBuilder spare) {
        spare.copyChars(charSequence);
        return Arrays.copyOf(spare.bytes(), spare.length());
    }

    public static String substring(String s, int beginIndex, int endIndex) {
        int realEndIndex;
        if (s == null) {
            return s;
        }
        int n = realEndIndex = s.length() > 0 ? s.length() - 1 : 0;
        if (endIndex > realEndIndex) {
            return s.substring(beginIndex);
        }
        return s.substring(beginIndex, endIndex);
    }

    public static boolean isAllOrWildcard(String[] data) {
        return CollectionUtils.isEmpty(data) || data.length == 1 && Strings.isAllOrWildcard(data[0]);
    }

    public static boolean isAllOrWildcard(String data) {
        return "_all".equals(data) || "*".equals(data);
    }

    public static String toString(MediaType mediaType, ToXContent toXContent) {
        return Strings.toString(mediaType, toXContent, false, false);
    }

    public static String toString(MediaType mediaType, ToXContent toXContent, ToXContent.Params params) {
        return Strings.toString(mediaType, toXContent, params, false, false);
    }

    public static String toString(XContentBuilder xContentBuilder) {
        return BytesReference.bytes((XContentBuilder)xContentBuilder).utf8ToString();
    }

    public static String toString(MediaType mediaType, ToXContent toXContent, boolean pretty, boolean human) {
        return Strings.toString(mediaType, toXContent, ToXContent.EMPTY_PARAMS, pretty, human);
    }

    private static String toString(MediaType mediaType, ToXContent toXContent, ToXContent.Params params, boolean pretty, boolean human) {
        try {
            XContentBuilder builder = Strings.createBuilder(mediaType, pretty, human);
            if (toXContent.isFragment()) {
                builder.startObject();
            }
            toXContent.toXContent(builder, params);
            if (toXContent.isFragment()) {
                builder.endObject();
            }
            return Strings.toString(builder);
        }
        catch (IOException e) {
            try {
                XContentBuilder builder = Strings.createBuilder(mediaType, pretty, human);
                builder.startObject();
                builder.field("error", "error building toString out of XContent: " + e.getMessage());
                builder.field("stack_trace", ExceptionsHelper.stackTrace((Throwable)e));
                builder.endObject();
                return Strings.toString(builder);
            }
            catch (IOException e2) {
                throw new OpenSearchException("cannot generate error message for deserialization", (Throwable)e, new Object[0]);
            }
        }
    }

    private static XContentBuilder createBuilder(MediaType mediaType, boolean pretty, boolean human) throws IOException {
        XContentBuilder builder = XContentBuilder.builder((XContent)mediaType.xContent());
        if (pretty) {
            builder.prettyPrint();
        }
        if (human) {
            builder.humanReadable(true);
        }
        return builder;
    }

    public static String cleanTruncate(String s, int length) {
        if (s == null) {
            return s;
        }
        if (length == 0) {
            return "";
        }
        if (length >= s.length()) {
            return s;
        }
        if (Character.isHighSurrogate(s.charAt(length - 1))) {
            --length;
        }
        return s.substring(0, length);
    }

    public static String padStart(String s, int minimumLength, char c) {
        if (s == null) {
            throw new NullPointerException("s");
        }
        if (s.length() >= minimumLength) {
            return s;
        }
        StringBuilder sb = new StringBuilder(minimumLength);
        for (int i = s.length(); i < minimumLength; ++i) {
            sb.append(c);
        }
        sb.append(s);
        return sb.toString();
    }

    public static String toLowercaseAscii(String in) {
        StringBuilder out = new StringBuilder();
        PrimitiveIterator.OfInt iter = in.codePoints().iterator();
        while (iter.hasNext()) {
            int codepoint = (Integer)iter.next();
            if (codepoint > 128) {
                out.appendCodePoint(codepoint);
                continue;
            }
            out.appendCodePoint(Character.toLowerCase(codepoint));
        }
        return out.toString();
    }
}

