/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.io.stream;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.opensearch.common.io.stream.StreamInput;

public class ByteBufferStreamInput
extends StreamInput {
    private final ByteBuffer buffer;

    public ByteBufferStreamInput(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    public byte readByte() throws IOException {
        if (!this.buffer.hasRemaining()) {
            throw new EOFException();
        }
        return this.buffer.get();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.buffer.remaining());
        this.buffer.get(b, off, len);
        return len;
    }

    public long skip(long n) throws IOException {
        if (n > (long)this.buffer.remaining()) {
            int ret = this.buffer.position();
            this.buffer.position(this.buffer.limit());
            return ret;
        }
        this.buffer.position((int)((long)this.buffer.position() + n));
        return n;
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (this.buffer.remaining() < len) {
            throw new EOFException();
        }
        this.buffer.get(b, offset, len);
    }

    public short readShort() throws IOException {
        try {
            return this.buffer.getShort();
        }
        catch (BufferUnderflowException ex) {
            EOFException eofException = new EOFException();
            eofException.initCause(ex);
            throw eofException;
        }
    }

    public int readInt() throws IOException {
        try {
            return this.buffer.getInt();
        }
        catch (BufferUnderflowException ex) {
            EOFException eofException = new EOFException();
            eofException.initCause(ex);
            throw eofException;
        }
    }

    public long readLong() throws IOException {
        try {
            return this.buffer.getLong();
        }
        catch (BufferUnderflowException ex) {
            EOFException eofException = new EOFException();
            eofException.initCause(ex);
            throw eofException;
        }
    }

    public void position(int newPosition) throws IOException {
        this.buffer.position(newPosition);
    }

    public int position() throws IOException {
        return this.buffer.position();
    }

    public void reset() throws IOException {
        this.buffer.reset();
    }

    public int available() throws IOException {
        return this.buffer.remaining();
    }

    protected void ensureCanReadBytes(int length) throws EOFException {
        if (this.buffer.remaining() < length) {
            throw new EOFException("tried to read: " + length + " bytes but only " + this.buffer.remaining() + " remaining");
        }
    }

    public void mark(int readlimit) {
        this.buffer.mark();
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
    }
}

