/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery;

import java.io.IOException;
import org.opensearch.cluster.coordination.PendingClusterStateStats;
import org.opensearch.cluster.coordination.PublishClusterStateStats;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class DiscoveryStats
implements Writeable,
ToXContentFragment {
    private final PendingClusterStateStats queueStats;
    private final PublishClusterStateStats publishStats;

    public DiscoveryStats(PendingClusterStateStats queueStats, PublishClusterStateStats publishStats) {
        this.queueStats = queueStats;
        this.publishStats = publishStats;
    }

    public DiscoveryStats(StreamInput in) throws IOException {
        this.queueStats = (PendingClusterStateStats)in.readOptionalWriteable(PendingClusterStateStats::new);
        this.publishStats = (PublishClusterStateStats)in.readOptionalWriteable(PublishClusterStateStats::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.queueStats);
        out.writeOptionalWriteable((Writeable)this.publishStats);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("discovery");
        if (this.queueStats != null) {
            this.queueStats.toXContent(builder, params);
        }
        if (this.publishStats != null) {
            this.publishStats.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public PendingClusterStateStats getQueueStats() {
        return this.queueStats;
    }

    public PublishClusterStateStats getPublishStats() {
        return this.publishStats;
    }

    static final class Fields {
        static final String DISCOVERY = "discovery";

        Fields() {
        }
    }
}

