/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.extensions.ExtensionsManager;
import org.opensearch.transport.TransportRequest;

public class OpenSearchRequest
extends TransportRequest {
    private static final Logger logger = LogManager.getLogger(OpenSearchRequest.class);
    private ExtensionsManager.OpenSearchRequestType requestType;

    public OpenSearchRequest(ExtensionsManager.OpenSearchRequestType requestType) {
        this.requestType = requestType;
    }

    public OpenSearchRequest(StreamInput in) throws IOException {
        super(in);
        this.requestType = (ExtensionsManager.OpenSearchRequestType)in.readEnum(ExtensionsManager.OpenSearchRequestType.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum((Enum)this.requestType);
    }

    public String toString() {
        return "OpenSearchRequest{requestType=" + this.requestType + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenSearchRequest that = (OpenSearchRequest)o;
        return Objects.equals((Object)this.requestType, (Object)that.requestType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestType});
    }

    public ExtensionsManager.OpenSearchRequestType getRequestType() {
        return this.requestType;
    }
}

