/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import java.io.IOException;
import java.util.Set;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.SegmentReplicationShardStats;
import org.opensearch.index.shard.ShardId;

public class SegmentReplicationPerGroupStats
implements Writeable,
ToXContentFragment {
    private final ShardId shardId;
    private final Set<SegmentReplicationShardStats> replicaStats;
    private final long rejectedRequestCount;

    public SegmentReplicationPerGroupStats(ShardId shardId, Set<SegmentReplicationShardStats> replicaStats, long rejectedRequestCount) {
        this.shardId = shardId;
        this.replicaStats = replicaStats;
        this.rejectedRequestCount = rejectedRequestCount;
    }

    public SegmentReplicationPerGroupStats(StreamInput in) throws IOException {
        this.shardId = new ShardId(in);
        this.replicaStats = in.readSet(SegmentReplicationShardStats::new);
        this.rejectedRequestCount = in.readVLong();
    }

    public Set<SegmentReplicationShardStats> getReplicaStats() {
        return this.replicaStats;
    }

    public long getRejectedRequestCount() {
        return this.rejectedRequestCount;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("rejected_requests", this.rejectedRequestCount);
        builder.startArray("replicas");
        for (SegmentReplicationShardStats stats : this.replicaStats) {
            stats.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeCollection(this.replicaStats);
        out.writeVLong(this.rejectedRequestCount);
    }

    public String toString() {
        return "SegmentReplicationPerGroupStats{replicaStats=" + this.replicaStats + ", rejectedRequestCount=" + this.rejectedRequestCount + "}";
    }
}

