/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec;

import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene95.Lucene95Codec;
import org.opensearch.common.Nullable;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.codec.PerFieldMappingPostingFormatCodec;
import org.opensearch.index.codec.customcodecs.ZstdCodec;
import org.opensearch.index.codec.customcodecs.ZstdNoDictCodec;
import org.opensearch.index.engine.EngineConfig;
import org.opensearch.index.mapper.MapperService;

public class CodecService {
    private final Map<String, Codec> codecs;
    public static final String DEFAULT_CODEC = "default";
    public static final String BEST_COMPRESSION_CODEC = "best_compression";
    public static final String LUCENE_DEFAULT_CODEC = "lucene_default";
    public static final String ZSTD_CODEC = "zstd";
    public static final String ZSTD_NO_DICT_CODEC = "zstd_no_dict";

    public CodecService(@Nullable MapperService mapperService, IndexSettings indexSettings, Logger logger) {
        MapBuilder codecs = MapBuilder.newMapBuilder();
        assert (null != indexSettings);
        int compressionLevel = indexSettings.getValue(EngineConfig.INDEX_CODEC_COMPRESSION_LEVEL_SETTING);
        if (mapperService == null) {
            codecs.put((Object)DEFAULT_CODEC, (Object)new Lucene95Codec());
            codecs.put((Object)BEST_COMPRESSION_CODEC, (Object)new Lucene95Codec(Lucene95Codec.Mode.BEST_COMPRESSION));
            codecs.put((Object)ZSTD_CODEC, (Object)new ZstdCodec(compressionLevel));
            codecs.put((Object)ZSTD_NO_DICT_CODEC, (Object)new ZstdNoDictCodec(compressionLevel));
        } else {
            codecs.put((Object)DEFAULT_CODEC, (Object)new PerFieldMappingPostingFormatCodec(Lucene95Codec.Mode.BEST_SPEED, mapperService, logger));
            codecs.put((Object)BEST_COMPRESSION_CODEC, (Object)new PerFieldMappingPostingFormatCodec(Lucene95Codec.Mode.BEST_COMPRESSION, mapperService, logger));
            codecs.put((Object)ZSTD_CODEC, (Object)new ZstdCodec(mapperService, logger, compressionLevel));
            codecs.put((Object)ZSTD_NO_DICT_CODEC, (Object)new ZstdNoDictCodec(mapperService, logger, compressionLevel));
        }
        codecs.put((Object)LUCENE_DEFAULT_CODEC, (Object)Codec.getDefault());
        for (String codec : Codec.availableCodecs()) {
            codecs.put((Object)codec, (Object)Codec.forName((String)codec));
        }
        this.codecs = codecs.immutableMap();
    }

    @Deprecated(since="2.9.0", forRemoval=true)
    public CodecService(@Nullable MapperService mapperService, Logger logger) {
        MapBuilder codecs = MapBuilder.newMapBuilder();
        if (mapperService == null) {
            codecs.put((Object)DEFAULT_CODEC, (Object)new Lucene95Codec());
            codecs.put((Object)BEST_COMPRESSION_CODEC, (Object)new Lucene95Codec(Lucene95Codec.Mode.BEST_COMPRESSION));
            codecs.put((Object)ZSTD_CODEC, (Object)new ZstdCodec());
            codecs.put((Object)ZSTD_NO_DICT_CODEC, (Object)new ZstdNoDictCodec());
        } else {
            IndexSettings indexSettings = mapperService.getIndexSettings();
            int compressionLevel = indexSettings == null ? 3 : indexSettings.getValue(EngineConfig.INDEX_CODEC_COMPRESSION_LEVEL_SETTING);
            codecs.put((Object)DEFAULT_CODEC, (Object)new PerFieldMappingPostingFormatCodec(Lucene95Codec.Mode.BEST_SPEED, mapperService, logger));
            codecs.put((Object)BEST_COMPRESSION_CODEC, (Object)new PerFieldMappingPostingFormatCodec(Lucene95Codec.Mode.BEST_COMPRESSION, mapperService, logger));
            codecs.put((Object)ZSTD_CODEC, (Object)new ZstdCodec(mapperService, logger, compressionLevel));
            codecs.put((Object)ZSTD_NO_DICT_CODEC, (Object)new ZstdNoDictCodec(mapperService, logger, compressionLevel));
        }
        codecs.put((Object)LUCENE_DEFAULT_CODEC, (Object)Codec.getDefault());
        for (String codec : Codec.availableCodecs()) {
            codecs.put((Object)codec, (Object)Codec.forName((String)codec));
        }
        this.codecs = codecs.immutableMap();
    }

    public Codec codec(String name) {
        Codec codec = this.codecs.get(name);
        if (codec == null) {
            throw new IllegalArgumentException("failed to find codec [" + name + "]");
        }
        return codec;
    }

    public String[] availableCodecs() {
        return this.codecs.keySet().toArray(new String[0]);
    }
}

