/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.snapshots.blobstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.OpenSearchParseException;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.snapshots.IndexShardSnapshotStatus;
import org.opensearch.index.snapshots.blobstore.IndexShardSnapshot;

public class RemoteStoreShardShallowCopySnapshot
implements ToXContentFragment,
IndexShardSnapshot {
    private final String snapshot;
    private final String version;
    private final long indexVersion;
    private final long startTime;
    private final long time;
    private final int totalFileCount;
    private final long totalSize;
    private final long primaryTerm;
    private final long commitGeneration;
    private final String remoteStoreRepository;
    private final String repositoryBasePath;
    private final String indexUUID;
    private final List<String> fileNames;
    static final String DEFAULT_VERSION = "1";
    static final String NAME = "name";
    static final String VERSION = "version";
    static final String INDEX_VERSION = "index_version";
    static final String START_TIME = "start_time";
    static final String TIME = "time";
    static final String INDEX_UUID = "index_uuid";
    static final String REMOTE_STORE_REPOSITORY = "remote_store_repository";
    static final String REPOSITORY_BASE_PATH = "remote_store_repository_base_path";
    static final String FILE_NAMES = "file_names";
    static final String PRIMARY_TERM = "primary_term";
    static final String COMMIT_GENERATION = "commit_generation";
    static final String TOTAL_FILE_COUNT = "number_of_files";
    static final String TOTAL_SIZE = "total_size";
    private static final ParseField PARSE_NAME = new ParseField("name", new String[0]);
    private static final ParseField PARSE_VERSION = new ParseField("version", new String[0]);
    private static final ParseField PARSE_PRIMARY_TERM = new ParseField("primary_term", new String[0]);
    private static final ParseField PARSE_COMMIT_GENERATION = new ParseField("commit_generation", new String[0]);
    private static final ParseField PARSE_INDEX_VERSION = new ParseField("index_version", new String[]{"index-version"});
    private static final ParseField PARSE_START_TIME = new ParseField("start_time", new String[0]);
    private static final ParseField PARSE_TIME = new ParseField("time", new String[0]);
    private static final ParseField PARSE_TOTAL_FILE_COUNT = new ParseField("number_of_files", new String[0]);
    private static final ParseField PARSE_TOTAL_SIZE = new ParseField("total_size", new String[0]);
    private static final ParseField PARSE_INDEX_UUID = new ParseField("index_uuid", new String[0]);
    private static final ParseField PARSE_REMOTE_STORE_REPOSITORY = new ParseField("remote_store_repository", new String[0]);
    private static final ParseField PARSE_REPOSITORY_BASE_PATH = new ParseField("remote_store_repository_base_path", new String[0]);
    private static final ParseField PARSE_FILE_NAMES = new ParseField("file_names", new String[0]);

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(VERSION, this.version);
        builder.field(NAME, this.snapshot);
        builder.field(INDEX_VERSION, this.indexVersion);
        builder.field(START_TIME, this.startTime);
        builder.field(TIME, this.time);
        builder.field(TOTAL_FILE_COUNT, this.totalFileCount);
        builder.field(TOTAL_SIZE, this.totalSize);
        builder.field(INDEX_UUID, this.indexUUID);
        builder.field(REMOTE_STORE_REPOSITORY, this.remoteStoreRepository);
        builder.field(COMMIT_GENERATION, this.commitGeneration);
        builder.field(PRIMARY_TERM, this.primaryTerm);
        builder.field(REPOSITORY_BASE_PATH, this.repositoryBasePath);
        builder.startArray(FILE_NAMES);
        for (String fileName : this.fileNames) {
            builder.value(fileName);
        }
        builder.endArray();
        return builder;
    }

    public RemoteStoreShardShallowCopySnapshot(String snapshot, long indexVersion, long primaryTerm, long commitGeneration, long startTime, long time, int totalFileCount, long totalSize, String indexUUID, String remoteStoreRepository, String repositoryBasePath, List<String> fileNames) {
        this.version = DEFAULT_VERSION;
        this.verifyParameters(this.version, snapshot, indexVersion, primaryTerm, commitGeneration, indexUUID, remoteStoreRepository, repositoryBasePath);
        this.snapshot = snapshot;
        this.indexVersion = indexVersion;
        this.primaryTerm = primaryTerm;
        this.commitGeneration = commitGeneration;
        this.startTime = startTime;
        this.time = time;
        this.totalFileCount = totalFileCount;
        this.totalSize = totalSize;
        this.indexUUID = indexUUID;
        this.remoteStoreRepository = remoteStoreRepository;
        this.repositoryBasePath = repositoryBasePath;
        this.fileNames = fileNames;
    }

    private RemoteStoreShardShallowCopySnapshot(String version, String snapshot, long indexVersion, long primaryTerm, long commitGeneration, long startTime, long time, int totalFileCount, long totalSize, String indexUUID, String remoteStoreRepository, String repositoryBasePath, List<String> fileNames) {
        this.verifyParameters(version, snapshot, indexVersion, primaryTerm, commitGeneration, indexUUID, remoteStoreRepository, repositoryBasePath);
        this.version = version;
        this.snapshot = snapshot;
        this.indexVersion = indexVersion;
        this.primaryTerm = primaryTerm;
        this.commitGeneration = commitGeneration;
        this.startTime = startTime;
        this.time = time;
        this.totalFileCount = totalFileCount;
        this.totalSize = totalSize;
        this.indexUUID = indexUUID;
        this.remoteStoreRepository = remoteStoreRepository;
        this.repositoryBasePath = repositoryBasePath;
        this.fileNames = fileNames;
    }

    public static RemoteStoreShardShallowCopySnapshot fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String snapshot = null;
        String version = null;
        long indexVersion = -1L;
        long startTime = 0L;
        long time = 0L;
        int totalFileCount = 0;
        long totalSize = 0L;
        String indexUUID = null;
        String remoteStoreRepository = null;
        String repositoryBasePath = null;
        long primaryTerm = -1L;
        long commitGeneration = -1L;
        ArrayList<String> fileNames = new ArrayList<String>();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        String currentFieldName = parser.currentName();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (PARSE_NAME.match(currentFieldName, parser.getDeprecationHandler())) {
                    snapshot = parser.text();
                    continue;
                }
                if (PARSE_VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                    version = parser.text();
                    continue;
                }
                if (PARSE_INDEX_VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexVersion = parser.longValue();
                    continue;
                }
                if (PARSE_PRIMARY_TERM.match(currentFieldName, parser.getDeprecationHandler())) {
                    primaryTerm = parser.longValue();
                    continue;
                }
                if (PARSE_COMMIT_GENERATION.match(currentFieldName, parser.getDeprecationHandler())) {
                    commitGeneration = parser.longValue();
                    continue;
                }
                if (PARSE_START_TIME.match(currentFieldName, parser.getDeprecationHandler())) {
                    startTime = parser.longValue();
                    continue;
                }
                if (PARSE_TIME.match(currentFieldName, parser.getDeprecationHandler())) {
                    time = parser.longValue();
                    continue;
                }
                if (PARSE_TOTAL_FILE_COUNT.match(currentFieldName, parser.getDeprecationHandler())) {
                    totalFileCount = parser.intValue();
                    continue;
                }
                if (PARSE_TOTAL_SIZE.match(currentFieldName, parser.getDeprecationHandler())) {
                    totalSize = parser.longValue();
                    continue;
                }
                if (PARSE_INDEX_UUID.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexUUID = parser.text();
                    continue;
                }
                if (PARSE_REMOTE_STORE_REPOSITORY.match(currentFieldName, parser.getDeprecationHandler())) {
                    remoteStoreRepository = parser.text();
                    continue;
                }
                if (PARSE_REPOSITORY_BASE_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                    repositoryBasePath = parser.text();
                    continue;
                }
                throw new OpenSearchParseException("unknown parameter [{}]", currentFieldName);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (PARSE_FILE_NAMES.match(currentFieldName, parser.getDeprecationHandler())) {
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        fileNames.add(parser.text());
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            parser.skipChildren();
        }
        return new RemoteStoreShardShallowCopySnapshot(version, snapshot, indexVersion, primaryTerm, commitGeneration, startTime, time, totalFileCount, totalSize, indexUUID, remoteStoreRepository, repositoryBasePath, fileNames);
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public long getCommitGeneration() {
        return this.commitGeneration;
    }

    public String getIndexUUID() {
        return this.indexUUID;
    }

    public String getRemoteStoreRepository() {
        return this.remoteStoreRepository;
    }

    public String getRepositoryBasePath() {
        return this.repositoryBasePath;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public long startTime() {
        return this.startTime;
    }

    public long time() {
        return this.time;
    }

    public int incrementalFileCount() {
        return 0;
    }

    public int totalFileCount() {
        return this.totalFileCount;
    }

    public long incrementalSize() {
        return 0L;
    }

    public long totalSize() {
        return this.totalSize;
    }

    private void verifyParameters(String version, String snapshot, long indexVersion, long primaryTerm, long commitGeneration, String indexUUID, String remoteStoreRepository, String repositoryBasePath) {
        String exceptionStr = null;
        if (version == null) {
            exceptionStr = "Invalid Version Provided";
        }
        if (snapshot == null) {
            exceptionStr = "Invalid/Missing Snapshot Name";
        }
        if (indexVersion < 0L) {
            exceptionStr = "Invalid Index Version";
        }
        if (primaryTerm < 0L) {
            exceptionStr = "Invalid Primary Term";
        }
        if (commitGeneration < 0L) {
            exceptionStr = "Invalid Commit Generation";
        }
        if (indexUUID == null) {
            exceptionStr = "Invalid/Missing Index UUID";
        }
        if (remoteStoreRepository == null) {
            exceptionStr = "Invalid/Missing Remote Store Repository";
        }
        if (repositoryBasePath == null) {
            exceptionStr = "Invalid/Missing Repository Base Path";
        }
        if (exceptionStr != null) {
            throw new IllegalArgumentException(exceptionStr);
        }
    }

    public RemoteStoreShardShallowCopySnapshot asClone(String targetSnapshotName, long startTime, long time) {
        return new RemoteStoreShardShallowCopySnapshot(targetSnapshotName, this.indexVersion, this.primaryTerm, this.commitGeneration, startTime, time, this.totalFileCount, this.totalSize, this.indexUUID, this.remoteStoreRepository, this.repositoryBasePath, this.fileNames);
    }

    @Override
    public IndexShardSnapshotStatus getIndexShardSnapshotStatus() {
        return IndexShardSnapshotStatus.newDone(this.startTime, this.time, this.incrementalFileCount(), this.totalFileCount, this.incrementalSize(), this.totalSize, null);
    }
}

