/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

final class ReplicaFileTracker {
    private final Map<String, Integer> refCounts = new HashMap<String, Integer>();

    ReplicaFileTracker() {
    }

    public synchronized void incRef(Collection<String> fileNames) {
        for (String fileName : fileNames) {
            this.refCounts.merge(fileName, 1, Integer::sum);
        }
    }

    public synchronized void decRef(Collection<String> fileNames) {
        for (String fileName : fileNames) {
            Integer curCount = this.refCounts.get(fileName);
            assert (curCount != null) : "fileName=" + fileName;
            assert (curCount > 0);
            if (curCount == 1) {
                this.refCounts.remove(fileName);
                continue;
            }
            this.refCounts.put(fileName, curCount - 1);
        }
    }

    public synchronized boolean canDelete(String fileName) {
        return !this.refCounts.containsKey(fileName);
    }
}

