/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRunnable;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.BlobStore;
import org.opensearch.index.translog.transfer.FileSnapshot;
import org.opensearch.index.translog.transfer.FileTransferException;
import org.opensearch.index.translog.transfer.TransferService;
import org.opensearch.threadpool.ThreadPool;

public class BlobStoreTransferService
implements TransferService {
    private final BlobStore blobStore;
    private final ThreadPool threadPool;
    private static final Logger logger = LogManager.getLogger(BlobStoreTransferService.class);

    public BlobStoreTransferService(BlobStore blobStore, ThreadPool threadPool) {
        this.blobStore = blobStore;
        this.threadPool = threadPool;
    }

    @Override
    public void uploadBlobAsync(String threadpoolName, FileSnapshot.TransferFileSnapshot fileSnapshot, Iterable<String> remoteTransferPath, ActionListener<FileSnapshot.TransferFileSnapshot> listener) {
        assert (remoteTransferPath instanceof BlobPath);
        BlobPath blobPath = (BlobPath)remoteTransferPath;
        this.threadPool.executor(threadpoolName).execute(ActionRunnable.wrap(listener, l -> {
            try (InputStream inputStream = fileSnapshot.inputStream();){
                this.blobStore.blobContainer(blobPath).writeBlobAtomic(fileSnapshot.getName(), inputStream, fileSnapshot.getContentLength(), true);
                l.onResponse(fileSnapshot);
            }
            catch (Exception e) {
                logger.error(() -> new ParameterizedMessage("Failed to upload blob {}", (Object)fileSnapshot.getName()), (Throwable)e);
                l.onFailure(new FileTransferException(fileSnapshot, (Throwable)e));
            }
        }));
    }

    @Override
    public void uploadBlob(FileSnapshot.TransferFileSnapshot fileSnapshot, Iterable<String> remoteTransferPath) throws IOException {
        assert (remoteTransferPath instanceof BlobPath);
        BlobPath blobPath = (BlobPath)remoteTransferPath;
        try (InputStream inputStream = fileSnapshot.inputStream();){
            this.blobStore.blobContainer(blobPath).writeBlobAtomic(fileSnapshot.getName(), inputStream, fileSnapshot.getContentLength(), true);
        }
    }

    @Override
    public InputStream downloadBlob(Iterable<String> path, String fileName) throws IOException {
        return this.blobStore.blobContainer((BlobPath)path).readBlob(fileName);
    }

    @Override
    public void deleteBlobs(Iterable<String> path, List<String> fileNames) throws IOException {
        this.blobStore.blobContainer((BlobPath)path).deleteBlobsIgnoringIfNotExists(fileNames);
    }

    @Override
    public void deleteBlobsAsync(String threadpoolName, Iterable<String> path, List<String> fileNames, ActionListener<Void> listener) {
        this.threadPool.executor(threadpoolName).execute(() -> {
            try {
                this.deleteBlobs(path, fileNames);
                listener.onResponse(null);
            }
            catch (IOException e) {
                listener.onFailure(e);
            }
        });
    }

    @Override
    public void delete(Iterable<String> path) throws IOException {
        this.blobStore.blobContainer((BlobPath)path).delete();
    }

    @Override
    public void deleteAsync(String threadpoolName, Iterable<String> path, ActionListener<Void> listener) {
        this.threadPool.executor(threadpoolName).execute(() -> {
            try {
                this.delete(path);
                listener.onResponse(null);
            }
            catch (IOException e) {
                listener.onFailure(e);
            }
        });
    }

    @Override
    public Set<String> listAll(Iterable<String> path) throws IOException {
        return this.blobStore.blobContainer((BlobPath)path).listBlobs().keySet();
    }

    @Override
    public Set<String> listFolders(Iterable<String> path) throws IOException {
        return this.blobStore.blobContainer((BlobPath)path).children().keySet();
    }

    @Override
    public void listFoldersAsync(String threadpoolName, Iterable<String> path, ActionListener<Set<String>> listener) {
        this.threadPool.executor(threadpoolName).execute(() -> {
            try {
                listener.onResponse(this.listFolders(path));
            }
            catch (IOException e) {
                listener.onFailure(e);
            }
        });
    }

    @Override
    public void listAllInSortedOrder(Iterable<String> path, int limit, ActionListener<List<BlobMetadata>> listener) {
        this.blobStore.blobContainer((BlobPath)path).listBlobsByPrefixInSortedOrder("", limit, BlobContainer.BlobNameSortOrder.LEXICOGRAPHIC, listener);
    }

    @Override
    public void listAllInSortedOrderAsync(String threadpoolName, Iterable<String> path, int limit, ActionListener<List<BlobMetadata>> listener) {
        this.threadPool.executor(threadpoolName).execute(() -> this.listAllInSortedOrder(path, limit, listener));
    }
}

