/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog.transfer;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.SetOnce;
import org.opensearch.index.remote.RemoteStoreUtils;

public class TranslogTransferMetadata {
    private final long primaryTerm;
    private final long generation;
    private final long minTranslogGeneration;
    private int count;
    private final SetOnce<Map<String, String>> generationToPrimaryTermMapper = new SetOnce();
    public static final String METADATA_SEPARATOR = "__";
    static final int BUFFER_SIZE = 4096;
    static final int CURRENT_VERSION = 1;
    static final String METADATA_CODEC = "md";
    private final long createdAt;

    public TranslogTransferMetadata(long primaryTerm, long generation, long minTranslogGeneration, int count) {
        this.primaryTerm = primaryTerm;
        this.generation = generation;
        this.minTranslogGeneration = minTranslogGeneration;
        this.count = count;
        this.createdAt = System.currentTimeMillis();
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public long getGeneration() {
        return this.generation;
    }

    public long getMinTranslogGeneration() {
        return this.minTranslogGeneration;
    }

    public int getCount() {
        return this.count;
    }

    public void setGenerationToPrimaryTermMapper(Map<String, String> generationToPrimaryTermMap) {
        this.generationToPrimaryTermMapper.set(generationToPrimaryTermMap);
    }

    public Map<String, String> getGenerationToPrimaryTermMapper() {
        return (Map)this.generationToPrimaryTermMapper.get();
    }

    public String getFileName() {
        return String.join((CharSequence)METADATA_SEPARATOR, Arrays.asList(RemoteStoreUtils.invertLong(this.primaryTerm), RemoteStoreUtils.invertLong(this.generation), RemoteStoreUtils.invertLong(this.createdAt), String.valueOf(1)));
    }

    public int hashCode() {
        return Objects.hash(this.primaryTerm, this.generation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslogTransferMetadata other = (TranslogTransferMetadata)o;
        return Objects.equals(this.primaryTerm, other.primaryTerm) && Objects.equals(this.generation, other.generation);
    }
}

