/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.fielddata.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.ToLongBiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.Accountable;
import org.opensearch.common.Nullable;
import org.opensearch.common.cache.Cache;
import org.opensearch.common.cache.CacheBuilder;
import org.opensearch.common.cache.RemovalListener;
import org.opensearch.common.cache.RemovalNotification;
import org.opensearch.common.cache.RemovalReason;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lucene.index.OpenSearchDirectoryReader;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.index.Index;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexFieldDataCache;
import org.opensearch.index.fielddata.LeafFieldData;
import org.opensearch.index.shard.ShardId;
import org.opensearch.index.shard.ShardUtils;

public class IndicesFieldDataCache
implements RemovalListener<Key, Accountable>,
Releasable {
    private static final Logger logger = LogManager.getLogger(IndicesFieldDataCache.class);
    public static final Setting<ByteSizeValue> INDICES_FIELDDATA_CACHE_SIZE_KEY = Setting.memorySizeSetting("indices.fielddata.cache.size", new ByteSizeValue(-1L), Setting.Property.NodeScope);
    private final IndexFieldDataCache.Listener indicesFieldDataCacheListener;
    private final Cache<Key, Accountable> cache;

    public IndicesFieldDataCache(Settings settings, IndexFieldDataCache.Listener indicesFieldDataCacheListener) {
        this.indicesFieldDataCacheListener = indicesFieldDataCacheListener;
        long sizeInBytes = INDICES_FIELDDATA_CACHE_SIZE_KEY.get(settings).getBytes();
        CacheBuilder<Key, Accountable> cacheBuilder = CacheBuilder.builder().removalListener(this);
        if (sizeInBytes > 0L) {
            cacheBuilder.setMaximumWeight(sizeInBytes).weigher(new FieldDataWeigher());
        }
        this.cache = cacheBuilder.build();
    }

    public void close() {
        this.cache.invalidateAll();
    }

    public IndexFieldDataCache buildIndexFieldDataCache(IndexFieldDataCache.Listener listener, Index index, String fieldName) {
        return new IndexFieldCache(logger, this.cache, index, fieldName, this.indicesFieldDataCacheListener, listener);
    }

    public Cache<Key, Accountable> getCache() {
        return this.cache;
    }

    @Override
    public void onRemoval(RemovalNotification<Key, Accountable> notification) {
        Key key = notification.getKey();
        assert (key != null && key.listeners != null);
        IndexFieldCache indexCache = key.indexCache;
        Accountable value = notification.getValue();
        for (IndexFieldDataCache.Listener listener : key.listeners) {
            try {
                listener.onRemoval(key.shardId, indexCache.fieldName, notification.getRemovalReason() == RemovalReason.EVICTED, value.ramBytesUsed());
            }
            catch (Exception e) {
                logger.error("Failed to call listener on field data cache unloading", (Throwable)e);
            }
        }
    }

    public static class Key {
        public final IndexFieldCache indexCache;
        public final IndexReader.CacheKey readerKey;
        public final ShardId shardId;
        public final List<IndexFieldDataCache.Listener> listeners = new ArrayList<IndexFieldDataCache.Listener>();

        Key(IndexFieldCache indexCache, IndexReader.CacheKey readerKey, @Nullable ShardId shardId) {
            this.indexCache = indexCache;
            this.readerKey = readerKey;
            this.shardId = shardId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.indexCache.equals(key.indexCache)) {
                return false;
            }
            return this.readerKey.equals(key.readerKey);
        }

        public int hashCode() {
            int result = this.indexCache.hashCode();
            result = 31 * result + this.readerKey.hashCode();
            return result;
        }
    }

    static class IndexFieldCache
    implements IndexFieldDataCache,
    IndexReader.ClosedListener {
        private final Logger logger;
        final Index index;
        final String fieldName;
        private final Cache<Key, Accountable> cache;
        private final IndexFieldDataCache.Listener[] listeners;

        IndexFieldCache(Logger logger, Cache<Key, Accountable> cache, Index index, String fieldName, IndexFieldDataCache.Listener ... listeners) {
            this.logger = logger;
            this.listeners = listeners;
            this.index = index;
            this.fieldName = fieldName;
            this.cache = cache;
        }

        @Override
        public <FD extends LeafFieldData, IFD extends IndexFieldData<FD>> FD load(LeafReaderContext context, IFD indexFieldData) throws Exception {
            ShardId shardId = ShardUtils.extractShardId(context.reader());
            IndexReader.CacheHelper cacheHelper = context.reader().getCoreCacheHelper();
            if (cacheHelper == null) {
                throw new IllegalArgumentException("Reader " + context.reader() + " does not support caching");
            }
            Key key = new Key(this, cacheHelper.getKey(), shardId);
            Accountable accountable = this.cache.computeIfAbsent(key, k -> {
                cacheHelper.addClosedListener((IndexReader.ClosedListener)this);
                Collections.addAll(k.listeners, this.listeners);
                Object fieldData = indexFieldData.loadDirect(context);
                for (IndexFieldDataCache.Listener listener : k.listeners) {
                    try {
                        listener.onCache(shardId, this.fieldName, (Accountable)fieldData);
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to call listener on atomic field data loading", (Throwable)e);
                    }
                }
                return fieldData;
            });
            return (FD)((LeafFieldData)accountable);
        }

        @Override
        public <FD extends LeafFieldData, IFD extends IndexFieldData.Global<FD>> IFD load(DirectoryReader indexReader, IFD indexFieldData) throws Exception {
            ShardId shardId = ShardUtils.extractShardId(indexReader);
            IndexReader.CacheHelper cacheHelper = indexReader.getReaderCacheHelper();
            if (cacheHelper == null) {
                throw new IllegalArgumentException("Reader " + indexReader + " does not support caching");
            }
            Key key = new Key(this, cacheHelper.getKey(), shardId);
            Accountable accountable = this.cache.computeIfAbsent(key, k -> {
                OpenSearchDirectoryReader.addReaderCloseListener(indexReader, this);
                Collections.addAll(k.listeners, this.listeners);
                Accountable ifd = (Accountable)indexFieldData.loadGlobalDirect(indexReader);
                for (IndexFieldDataCache.Listener listener : k.listeners) {
                    try {
                        listener.onCache(shardId, this.fieldName, ifd);
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to call listener on global ordinals loading", (Throwable)e);
                    }
                }
                return ifd;
            });
            return (IFD)((IndexFieldData.Global)accountable);
        }

        public void onClose(IndexReader.CacheKey key) throws IOException {
            this.cache.invalidate(new Key(this, key, null));
        }

        @Override
        public void clear() {
            for (Key key : this.cache.keys()) {
                if (!key.indexCache.index.equals((Object)this.index)) continue;
                this.cache.invalidate(key);
            }
            this.cache.refresh();
        }

        @Override
        public void clear(String fieldName) {
            for (Key key : this.cache.keys()) {
                if (!key.indexCache.index.equals((Object)this.index) || !key.indexCache.fieldName.equals(fieldName)) continue;
                this.cache.invalidate(key);
            }
            this.cache.refresh();
        }
    }

    public static class FieldDataWeigher
    implements ToLongBiFunction<Key, Accountable> {
        @Override
        public long applyAsLong(Key key, Accountable ramUsage) {
            int weight = (int)Math.min(ramUsage.ramBytesUsed(), Integer.MAX_VALUE);
            return weight == 0 ? 1L : (long)weight;
        }
    }
}

