/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;

public class RepositoryStats
implements Writeable {
    public static final RepositoryStats EMPTY_STATS = new RepositoryStats(Collections.emptyMap());
    public final Map<String, Long> requestCounts;

    public RepositoryStats(Map<String, Long> requestCounts) {
        this.requestCounts = Collections.unmodifiableMap(requestCounts);
    }

    public RepositoryStats(StreamInput in) throws IOException {
        this.requestCounts = in.readMap(StreamInput::readString, StreamInput::readLong);
    }

    public RepositoryStats merge(RepositoryStats otherStats) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.putAll(this.requestCounts);
        for (Map.Entry<String, Long> entry : otherStats.requestCounts.entrySet()) {
            result.merge(entry.getKey(), entry.getValue(), Math::addExact);
        }
        return new RepositoryStats(result);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.requestCounts, StreamOutput::writeString, StreamOutput::writeLong);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryStats that = (RepositoryStats)o;
        return this.requestCounts.equals(that.requestCounts);
    }

    public int hashCode() {
        return Objects.hash(this.requestCounts);
    }

    public String toString() {
        return "RepositoryStats{requestCounts=" + this.requestCounts + "}";
    }
}

