/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.opensearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.common.regex.Regex;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.rest.action.RestBuilderListener;

public class RestGetAliasesAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_alias"), new RestHandler.Route(RestRequest.Method.GET, "/_aliases"), new RestHandler.Route(RestRequest.Method.GET, "/_alias/{name}"), new RestHandler.Route(RestRequest.Method.HEAD, "/_alias/{name}"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_alias"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/_alias"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_alias/{name}"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/_alias/{name}")));
    }

    @Override
    public String getName() {
        return "get_aliases_action";
    }

    static RestResponse buildRestResponse(boolean aliasesExplicitlyRequested, String[] requestedAliases, Map<String, List<AliasMetadata>> responseAliasMap, XContentBuilder builder) throws Exception {
        RestStatus status;
        int i;
        HashSet<String> indicesToDisplay = new HashSet<String>();
        HashSet<String> returnedAliasNames = new HashSet<String>();
        for (Map.Entry<String, List<AliasMetadata>> cursor : responseAliasMap.entrySet()) {
            for (AliasMetadata aliasMetadata : cursor.getValue()) {
                if (aliasesExplicitlyRequested) {
                    indicesToDisplay.add(cursor.getKey());
                }
                returnedAliasNames.add(aliasMetadata.alias());
            }
        }
        TreeSet<String> missingAliases = new TreeSet<String>();
        int firstWildcardIndex = requestedAliases.length;
        for (i = 0; i < requestedAliases.length; ++i) {
            if (!Regex.isSimpleMatchPattern(requestedAliases[i])) continue;
            firstWildcardIndex = i;
            break;
        }
        for (i = 0; i < requestedAliases.length; ++i) {
            int j;
            if ("_all".equals(requestedAliases[i]) || Regex.isSimpleMatchPattern(requestedAliases[i]) || i > firstWildcardIndex && requestedAliases[i].charAt(0) == '-') continue;
            for (j = Math.max(i + 1, firstWildcardIndex); j < requestedAliases.length && (requestedAliases[j].charAt(0) != '-' || !Regex.simpleMatch(requestedAliases[j].substring(1), requestedAliases[i]) && !"_all".equals(requestedAliases[j].substring(1))); ++j) {
            }
            if (j != requestedAliases.length || returnedAliasNames.contains(requestedAliases[i])) continue;
            missingAliases.add(requestedAliases[i]);
        }
        builder.startObject();
        if (missingAliases.isEmpty()) {
            status = RestStatus.OK;
        } else {
            status = RestStatus.NOT_FOUND;
            String message = missingAliases.size() == 1 ? String.format(Locale.ROOT, "alias [%s] missing", Strings.collectionToCommaDelimitedString(missingAliases)) : String.format(Locale.ROOT, "aliases [%s] missing", Strings.collectionToCommaDelimitedString(missingAliases));
            builder.field("error", message);
            builder.field("status", status.getStatus());
        }
        for (Map.Entry<String, List<AliasMetadata>> entry : responseAliasMap.entrySet()) {
            if (aliasesExplicitlyRequested && (!aliasesExplicitlyRequested || !indicesToDisplay.contains(entry.getKey()))) continue;
            builder.startObject(entry.getKey());
            builder.startObject("aliases");
            for (AliasMetadata alias : entry.getValue()) {
                AliasMetadata.Builder.toXContent(alias, builder, ToXContent.EMPTY_PARAMS);
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return new BytesRestResponse(status, builder);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        final boolean namesProvided = request.hasParam("name");
        final String[] aliases = request.paramAsStringArrayOrEmptyIfAll("name");
        GetAliasesRequest getAliasesRequest = new GetAliasesRequest(aliases);
        String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        getAliasesRequest.indices(indices);
        getAliasesRequest.indicesOptions(IndicesOptions.fromRequest(request, getAliasesRequest.indicesOptions()));
        getAliasesRequest.local(request.paramAsBoolean("local", getAliasesRequest.local()));
        return channel -> client.admin().indices().getAliases(getAliasesRequest, (ActionListener<GetAliasesResponse>)new RestBuilderListener<GetAliasesResponse>(channel){

            @Override
            public RestResponse buildResponse(GetAliasesResponse response, XContentBuilder builder) throws Exception {
                return RestGetAliasesAction.buildRestResponse(namesProvided, aliases, response.getAliases(), builder);
            }
        });
    }
}

