/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.opensearch.action.admin.indices.template.get.GetComponentTemplateAction;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestStatus;
import org.opensearch.rest.action.RestToXContentListener;

public class RestGetComponentTemplateAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestGetComponentTemplateAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_component_template"), new RestHandler.Route(RestRequest.Method.GET, "/_component_template/{name}"), new RestHandler.Route(RestRequest.Method.HEAD, "/_component_template/{name}"));
    }

    @Override
    public String getName() {
        return "get_component_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        GetComponentTemplateAction.Request getRequest = new GetComponentTemplateAction.Request(request.param("name"));
        getRequest.local(request.paramAsBoolean("local", getRequest.local()));
        getRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", getRequest.clusterManagerNodeTimeout()));
        RestGetComponentTemplateAction.parseDeprecatedMasterTimeoutParameter(getRequest, request);
        final boolean implicitAll = getRequest.name() == null;
        return channel -> client.execute(GetComponentTemplateAction.INSTANCE, getRequest, new RestToXContentListener<GetComponentTemplateAction.Response>(channel){

            @Override
            protected RestStatus getStatus(GetComponentTemplateAction.Response response) {
                boolean templateExists = !response.getComponentTemplates().isEmpty();
                return templateExists || implicitAll ? RestStatus.OK : RestStatus.NOT_FOUND;
            }
        });
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }
}

