/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.ParsedMultiBucketAggregation;
import org.opensearch.search.aggregations.bucket.filter.Filters;

public class ParsedFilters
extends ParsedMultiBucketAggregation<ParsedBucket>
implements Filters {
    private Map<String, ParsedBucket> bucketMap;
    private static final ObjectParser<ParsedFilters, Void> PARSER = new ObjectParser(ParsedFilters.class.getSimpleName(), true, ParsedFilters::new);

    @Override
    public String getType() {
        return "filters";
    }

    @Override
    public List<? extends Filters.Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public ParsedBucket getBucketByKey(String key) {
        if (this.bucketMap == null) {
            this.bucketMap = new HashMap<String, ParsedBucket>(this.buckets.size());
            for (ParsedBucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKey(), bucket);
            }
        }
        return this.bucketMap.get(key);
    }

    public static ParsedFilters fromXContent(XContentParser parser, String name) throws IOException {
        ParsedFilters aggregation = (ParsedFilters)PARSER.parse(parser, null);
        aggregation.setName(name);
        if (!aggregation.keyed) {
            int i = 0;
            for (ParsedBucket bucket : aggregation.buckets) {
                assert (bucket.key == null);
                bucket.key = String.valueOf(i);
                ++i;
            }
        }
        return aggregation;
    }

    static {
        ParsedFilters.declareMultiBucketAggregationFields(PARSER, (CheckedFunction<XContentParser, ParsedMultiBucketAggregation.ParsedBucket, IOException>)((CheckedFunction)parser -> ParsedBucket.fromXContent(parser, false)), (CheckedFunction<XContentParser, ParsedMultiBucketAggregation.ParsedBucket, IOException>)((CheckedFunction)parser -> ParsedBucket.fromXContent(parser, true)));
    }

    public static class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements Filters.Bucket {
        private String key;

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            return this.key;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.isKeyed()) {
                builder.startObject(this.key);
            } else {
                builder.startObject();
            }
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            this.getAggregations().toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        static ParsedBucket fromXContent(XContentParser parser, boolean keyed) throws IOException {
            ParsedBucket bucket = new ParsedBucket();
            bucket.setKeyed(keyed);
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (keyed) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
                bucket.key = currentFieldName;
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            }
            ArrayList aggregations = new ArrayList();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (!Aggregation.CommonFields.DOC_COUNT.getPreferredName().equals(currentFieldName)) continue;
                    bucket.setDocCount(parser.longValue());
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                XContentParserUtils.parseTypedKeysObject((XContentParser)parser, (String)"#", Aggregation.class, aggregations::add);
            }
            bucket.setAggregations(new Aggregations(aggregations));
            return bucket;
        }
    }
}

