/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class AbstractPipelineAggregationBuilder<PAB extends AbstractPipelineAggregationBuilder<PAB>>
extends PipelineAggregationBuilder {
    public static final ParseField BUCKETS_PATH_FIELD = new ParseField("buckets_path", new String[0]);
    protected final String type;
    protected Map<String, Object> metadata;

    protected AbstractPipelineAggregationBuilder(String name, String type, String[] bucketsPaths) {
        super(name, bucketsPaths);
        if (type == null) {
            throw new IllegalArgumentException("[type] must not be null: [" + name + "]");
        }
        this.type = type;
    }

    protected AbstractPipelineAggregationBuilder(StreamInput in, String type) throws IOException {
        this(in.readString(), type, in.readStringArray());
        this.metadata = in.readMap();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringArray(this.bucketsPaths);
        out.writeMap(this.metadata);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public String type() {
        return this.type;
    }

    protected abstract PipelineAggregator createInternal(Map<String, Object> var1);

    @Override
    public final PipelineAggregator create() {
        PipelineAggregator aggregator = this.createInternal(this.metadata);
        return aggregator;
    }

    public PAB setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return (PAB)this;
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        if (this.metadata != null) {
            builder.field("meta", this.metadata);
        }
        builder.startObject(this.type);
        if (!this.overrideBucketsPath() && this.bucketsPaths != null) {
            builder.startArray(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName());
            for (String path : this.bucketsPaths) {
                builder.value(path);
            }
            builder.endArray();
        }
        this.internalXContent(builder, params);
        builder.endObject();
        return builder.endObject();
    }

    protected boolean overrideBucketsPath() {
        return false;
    }

    protected abstract XContentBuilder internalXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.bucketsPaths), this.metadata, this.name, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPipelineAggregationBuilder other = (AbstractPipelineAggregationBuilder)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.name, other.name) && Objects.equals(this.metadata, other.metadata) && Objects.deepEquals(this.bucketsPaths, other.bucketsPaths);
    }

    @Override
    public String getType() {
        return this.type;
    }
}

