/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.io.stream.NamedWriteable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.opensearch.search.aggregations.pipeline.SimpleValue;

public class InternalSimpleValue
extends InternalNumericMetricsAggregation.SingleValue
implements SimpleValue {
    public static final String NAME = "simple_value";
    protected final double value;

    public InternalSimpleValue(String name, double value, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, metadata);
        this.format = formatter;
        this.value = value;
    }

    public InternalSimpleValue(StreamInput in) throws IOException {
        super(in);
        this.format = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
        this.value = in.readDouble();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.format);
        out.writeDouble(this.value);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public double value() {
        return this.value;
    }

    public double getValue() {
        return this.value;
    }

    DocValueFormat formatter() {
        return this.format;
    }

    @Override
    public InternalSimpleValue reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !Double.isInfinite(this.value) && !Double.isNaN(this.value);
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), hasValue ? Double.valueOf(this.value) : null);
        if (hasValue && this.format != DocValueFormat.RAW) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(this.value).toString());
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalSimpleValue other = (InternalSimpleValue)obj;
        return Objects.equals(this.value, other.value);
    }
}

