/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.support;

import java.io.IOException;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.opensearch.common.Rounding;
import org.opensearch.common.lucene.ScorerAware;
import org.opensearch.common.util.CollectionUtils;
import org.opensearch.index.fielddata.AbstractSortingNumericDocValues;
import org.opensearch.index.fielddata.DocValueBits;
import org.opensearch.index.fielddata.FieldData;
import org.opensearch.index.fielddata.GeoShapeValue;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexGeoPointFieldData;
import org.opensearch.index.fielddata.IndexNumericFieldData;
import org.opensearch.index.fielddata.IndexOrdinalsFieldData;
import org.opensearch.index.fielddata.LeafGeoPointFieldData;
import org.opensearch.index.fielddata.LeafGeoShapeFieldData;
import org.opensearch.index.fielddata.LeafNumericFieldData;
import org.opensearch.index.fielddata.LeafOrdinalsFieldData;
import org.opensearch.index.fielddata.MultiGeoPointValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.index.fielddata.SortingBinaryDocValues;
import org.opensearch.index.fielddata.SortingNumericDoubleValues;
import org.opensearch.index.fielddata.plain.AbstractGeoShapeIndexFieldData;
import org.opensearch.index.mapper.RangeType;
import org.opensearch.script.AggregationScript;
import org.opensearch.search.aggregations.AggregationExecutionException;
import org.opensearch.search.aggregations.support.ValueType;
import org.opensearch.search.aggregations.support.values.ScriptBytesValues;
import org.opensearch.search.aggregations.support.values.ScriptDoubleValues;
import org.opensearch.search.aggregations.support.values.ScriptLongValues;

public abstract class ValuesSource {
    public abstract SortedBinaryDocValues bytesValues(LeafReaderContext var1) throws IOException;

    public abstract DocValueBits docsWithValue(LeafReaderContext var1) throws IOException;

    public boolean needsScores() {
        return false;
    }

    public abstract Function<Rounding, Rounding.Prepared> roundingPreparer(IndexReader var1) throws IOException;

    public boolean hasGlobalOrdinals() {
        return false;
    }

    public static abstract class GeoShape
    extends ValuesSource {
        public static final GeoShape EMPTY = new GeoShape(){

            @Override
            public GeoShapeValue getGeoShapeValues(LeafReaderContext context) {
                return org.opensearch.index.fielddata.FieldData.emptyGeoShape();
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return org.opensearch.index.fielddata.FieldData.emptySortedBinary();
            }
        };

        @Override
        public DocValueBits docsWithValue(LeafReaderContext context) {
            GeoShapeValue geoShapeValue = this.getGeoShapeValues(context);
            return org.opensearch.index.fielddata.FieldData.docsWithValue(geoShapeValue);
        }

        @Override
        public Function<Rounding, Rounding.Prepared> roundingPreparer(IndexReader reader) {
            throw new AggregationExecutionException("can't round a [GEO_SHAPE]");
        }

        public abstract GeoShapeValue getGeoShapeValues(LeafReaderContext var1);

        public static class FieldData
        extends GeoShape {
            protected final AbstractGeoShapeIndexFieldData indexFieldData;

            public FieldData(AbstractGeoShapeIndexFieldData indexFieldData) {
                this.indexFieldData = indexFieldData;
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return ((LeafGeoShapeFieldData)this.indexFieldData.load(context)).getBytesValues();
            }

            @Override
            public GeoShapeValue getGeoShapeValues(LeafReaderContext context) {
                return ((LeafGeoShapeFieldData)this.indexFieldData.load(context)).getGeoShapeValue();
            }
        }
    }

    public static abstract class GeoPoint
    extends ValuesSource {
        public static final GeoPoint EMPTY = new GeoPoint(){

            @Override
            public MultiGeoPointValues geoPointValues(LeafReaderContext context) {
                return FieldData.emptyMultiGeoPoints();
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return FieldData.emptySortedBinary();
            }
        };

        @Override
        public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
            MultiGeoPointValues geoPoints = this.geoPointValues(context);
            return FieldData.docsWithValue(geoPoints);
        }

        @Override
        public final Function<Rounding, Rounding.Prepared> roundingPreparer(IndexReader reader) throws IOException {
            throw new AggregationExecutionException("can't round a [GEO_POINT]");
        }

        public abstract MultiGeoPointValues geoPointValues(LeafReaderContext var1);

        public static class Fielddata
        extends GeoPoint {
            protected final IndexGeoPointFieldData indexFieldData;

            public Fielddata(IndexGeoPointFieldData indexFieldData) {
                this.indexFieldData = indexFieldData;
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                return ((LeafGeoPointFieldData)this.indexFieldData.load(context)).getBytesValues();
            }

            @Override
            public MultiGeoPointValues geoPointValues(LeafReaderContext context) {
                return ((LeafGeoPointFieldData)this.indexFieldData.load(context)).getGeoPointValues();
            }
        }
    }

    public static abstract class Numeric
    extends ValuesSource {
        public static final Numeric EMPTY = new Numeric(){

            @Override
            public boolean isFloatingPoint() {
                return false;
            }

            @Override
            public boolean isBigInteger() {
                return false;
            }

            @Override
            public SortedNumericDocValues longValues(LeafReaderContext context) {
                return DocValues.emptySortedNumeric();
            }

            @Override
            public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
                return org.opensearch.index.fielddata.FieldData.emptySortedNumericDoubles();
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return org.opensearch.index.fielddata.FieldData.emptySortedBinary();
            }
        };

        public abstract boolean isFloatingPoint();

        public abstract boolean isBigInteger();

        public abstract SortedNumericDocValues longValues(LeafReaderContext var1) throws IOException;

        public abstract SortedNumericDoubleValues doubleValues(LeafReaderContext var1) throws IOException;

        @Override
        public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
            if (this.isFloatingPoint() || this.isBigInteger()) {
                SortedNumericDoubleValues values = this.doubleValues(context);
                return org.opensearch.index.fielddata.FieldData.docsWithValue(values);
            }
            SortedNumericDocValues values = this.longValues(context);
            return org.opensearch.index.fielddata.FieldData.docsWithValue(values);
        }

        @Override
        public Function<Rounding, Rounding.Prepared> roundingPreparer(IndexReader reader) throws IOException {
            return Rounding::prepareForUnknown;
        }

        public static class Script
        extends Numeric {
            private final AggregationScript.LeafFactory script;
            private final ValueType scriptValueType;

            public Script(AggregationScript.LeafFactory script, ValueType scriptValueType) {
                this.script = script;
                this.scriptValueType = scriptValueType;
            }

            @Override
            public boolean isFloatingPoint() {
                return this.scriptValueType != null ? this.scriptValueType == ValueType.DOUBLE : true;
            }

            @Override
            public boolean isBigInteger() {
                return this.scriptValueType != null ? this.scriptValueType == ValueType.UNSIGNED_LONG : false;
            }

            @Override
            public SortedNumericDocValues longValues(LeafReaderContext context) throws IOException {
                return new ScriptLongValues(this.script.newInstance(context));
            }

            @Override
            public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
                return new ScriptDoubleValues(this.script.newInstance(context));
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return new ScriptBytesValues(this.script.newInstance(context));
            }

            @Override
            public boolean needsScores() {
                return this.script.needs_score();
            }
        }

        public static class FieldData
        extends Numeric {
            protected final IndexNumericFieldData indexFieldData;

            public FieldData(IndexNumericFieldData indexFieldData) {
                this.indexFieldData = indexFieldData;
            }

            @Override
            public boolean isFloatingPoint() {
                return this.indexFieldData.getNumericType().isFloatingPoint();
            }

            @Override
            public boolean isBigInteger() {
                return this.indexFieldData.getNumericType() == IndexNumericFieldData.NumericType.UNSIGNED_LONG;
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                return ((LeafNumericFieldData)this.indexFieldData.load(context)).getBytesValues();
            }

            @Override
            public SortedNumericDocValues longValues(LeafReaderContext context) {
                return ((LeafNumericFieldData)this.indexFieldData.load(context)).getLongValues();
            }

            @Override
            public SortedNumericDoubleValues doubleValues(LeafReaderContext context) {
                return ((LeafNumericFieldData)this.indexFieldData.load(context)).getDoubleValues();
            }
        }

        public static class WithScript
        extends Numeric {
            private final Numeric delegate;
            private final AggregationScript.LeafFactory script;

            public WithScript(Numeric delegate, AggregationScript.LeafFactory script) {
                this.delegate = delegate;
                this.script = script;
            }

            @Override
            public boolean isFloatingPoint() {
                return true;
            }

            @Override
            public boolean isBigInteger() {
                return false;
            }

            @Override
            public boolean needsScores() {
                return this.script.needs_score();
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return new Bytes.WithScript.BytesValues(this.delegate.bytesValues(context), this.script.newInstance(context));
            }

            @Override
            public SortedNumericDocValues longValues(LeafReaderContext context) throws IOException {
                return new LongValues(this.delegate.longValues(context), this.script.newInstance(context));
            }

            @Override
            public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
                return new DoubleValues(this.delegate.doubleValues(context), this.script.newInstance(context));
            }

            static class DoubleValues
            extends SortingNumericDoubleValues
            implements ScorerAware {
                private final SortedNumericDoubleValues doubleValues;
                private final AggregationScript script;

                DoubleValues(SortedNumericDoubleValues values, AggregationScript script) {
                    this.doubleValues = values;
                    this.script = script;
                }

                @Override
                public void setScorer(Scorable scorer) {
                    this.script.setScorer(scorer);
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    if (this.doubleValues.advanceExact(target)) {
                        this.resize(this.doubleValues.docValueCount());
                        this.script.setDocument(target);
                        for (int i = 0; i < this.docValueCount(); ++i) {
                            this.script.setNextAggregationValue(this.doubleValues.nextValue());
                            this.values[i] = this.script.runAsDouble();
                        }
                        this.sort();
                        return true;
                    }
                    return false;
                }
            }

            static class LongValues
            extends AbstractSortingNumericDocValues
            implements ScorerAware {
                private final SortedNumericDocValues longValues;
                private final AggregationScript script;

                LongValues(SortedNumericDocValues values, AggregationScript script) {
                    this.longValues = values;
                    this.script = script;
                }

                @Override
                public void setScorer(Scorable scorer) {
                    this.script.setScorer(scorer);
                }

                public boolean advanceExact(int target) throws IOException {
                    if (this.longValues.advanceExact(target)) {
                        this.resize(this.longValues.docValueCount());
                        this.script.setDocument(target);
                        for (int i = 0; i < this.docValueCount(); ++i) {
                            this.script.setNextAggregationValue(this.longValues.nextValue());
                            this.values[i] = this.script.runAsLong();
                        }
                        this.sort();
                        return true;
                    }
                    return false;
                }
            }
        }
    }

    public static abstract class Bytes
    extends ValuesSource {
        @Override
        public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
            SortedBinaryDocValues bytes = this.bytesValues(context);
            return org.opensearch.index.fielddata.FieldData.docsWithValue(bytes);
        }

        @Override
        public final Function<Rounding, Rounding.Prepared> roundingPreparer(IndexReader reader) throws IOException {
            throw new AggregationExecutionException("can't round a [BYTES]");
        }

        public static class WithScript
        extends Bytes {
            private final ValuesSource delegate;
            private final AggregationScript.LeafFactory script;

            public WithScript(ValuesSource delegate, AggregationScript.LeafFactory script) {
                this.delegate = delegate;
                this.script = script;
            }

            @Override
            public boolean needsScores() {
                return this.script.needs_score();
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return new BytesValues(this.delegate.bytesValues(context), this.script.newInstance(context));
            }

            static class BytesValues
            extends SortingBinaryDocValues
            implements ScorerAware {
                private final SortedBinaryDocValues bytesValues;
                private final AggregationScript script;

                BytesValues(SortedBinaryDocValues bytesValues, AggregationScript script) {
                    this.bytesValues = bytesValues;
                    this.script = script;
                }

                @Override
                public void setScorer(Scorable scorer) {
                    this.script.setScorer(scorer);
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    if (this.bytesValues.advanceExact(doc)) {
                        this.count = this.bytesValues.docValueCount();
                        this.grow();
                        this.script.setDocument(doc);
                        for (int i = 0; i < this.count; ++i) {
                            BytesRef value = this.bytesValues.nextValue();
                            this.script.setNextAggregationValue(value.utf8ToString());
                            Object run = this.script.execute();
                            CollectionUtils.ensureNoSelfReferences(run, "ValuesSource.BytesValues script");
                            this.values[i].copyChars((CharSequence)run.toString());
                        }
                        this.sort();
                        return true;
                    }
                    this.count = 0;
                    this.grow();
                    return false;
                }
            }
        }

        public static class Script
        extends Bytes {
            private final AggregationScript.LeafFactory script;

            public Script(AggregationScript.LeafFactory script) {
                this.script = script;
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return new ScriptBytesValues(this.script.newInstance(context));
            }

            @Override
            public boolean needsScores() {
                return this.script.needs_score();
            }
        }

        public static class FieldData
        extends Bytes {
            protected final IndexFieldData<?> indexFieldData;

            public FieldData(IndexFieldData<?> indexFieldData) {
                this.indexFieldData = indexFieldData;
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                return this.indexFieldData.load(context).getBytesValues();
            }
        }

        public static abstract class WithOrdinals
        extends Bytes {
            public static final WithOrdinals EMPTY = new WithOrdinals(){

                @Override
                public SortedSetDocValues ordinalsValues(LeafReaderContext context) {
                    return DocValues.emptySortedSet();
                }

                @Override
                public SortedSetDocValues globalOrdinalsValues(LeafReaderContext context) {
                    return DocValues.emptySortedSet();
                }

                @Override
                public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                    return org.opensearch.index.fielddata.FieldData.emptySortedBinary();
                }

                @Override
                public LongUnaryOperator globalOrdinalsMapping(LeafReaderContext context) throws IOException {
                    return LongUnaryOperator.identity();
                }
            };

            @Override
            public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
                SortedSetDocValues ordinals = this.ordinalsValues(context);
                return org.opensearch.index.fielddata.FieldData.docsWithValue(ordinals);
            }

            public abstract SortedSetDocValues ordinalsValues(LeafReaderContext var1) throws IOException;

            public abstract SortedSetDocValues globalOrdinalsValues(LeafReaderContext var1) throws IOException;

            public boolean supportsGlobalOrdinalsMapping() {
                return true;
            }

            @Override
            public boolean hasGlobalOrdinals() {
                return true;
            }

            public abstract LongUnaryOperator globalOrdinalsMapping(LeafReaderContext var1) throws IOException;

            public long globalMaxOrd(IndexSearcher indexSearcher) throws IOException {
                IndexReader indexReader = indexSearcher.getIndexReader();
                if (indexReader.leaves().isEmpty()) {
                    return 0L;
                }
                LeafReaderContext atomicReaderContext = (LeafReaderContext)indexReader.leaves().get(0);
                SortedSetDocValues values = this.globalOrdinalsValues(atomicReaderContext);
                return values.getValueCount();
            }

            public static class FieldData
            extends WithOrdinals {
                protected final IndexOrdinalsFieldData indexFieldData;

                public FieldData(IndexOrdinalsFieldData indexFieldData) {
                    this.indexFieldData = indexFieldData;
                }

                @Override
                public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                    LeafOrdinalsFieldData atomicFieldData = (LeafOrdinalsFieldData)this.indexFieldData.load(context);
                    return atomicFieldData.getBytesValues();
                }

                @Override
                public SortedSetDocValues ordinalsValues(LeafReaderContext context) {
                    LeafOrdinalsFieldData atomicFieldData = (LeafOrdinalsFieldData)this.indexFieldData.load(context);
                    return atomicFieldData.getOrdinalsValues();
                }

                @Override
                public SortedSetDocValues globalOrdinalsValues(LeafReaderContext context) {
                    IndexOrdinalsFieldData global = this.indexFieldData.loadGlobal((DirectoryReader)context.parent.reader());
                    LeafOrdinalsFieldData atomicFieldData = (LeafOrdinalsFieldData)global.load(context);
                    return atomicFieldData.getOrdinalsValues();
                }

                @Override
                public boolean supportsGlobalOrdinalsMapping() {
                    return this.indexFieldData.supportsGlobalOrdinalsMapping();
                }

                @Override
                public LongUnaryOperator globalOrdinalsMapping(LeafReaderContext context) throws IOException {
                    IndexOrdinalsFieldData global = this.indexFieldData.loadGlobal((DirectoryReader)context.parent.reader());
                    OrdinalMap map = global.getOrdinalMap();
                    if (map == null) {
                        return LongUnaryOperator.identity();
                    }
                    LongValues segmentToGlobalOrd = map.getGlobalOrds(context.ord);
                    return arg_0 -> ((LongValues)segmentToGlobalOrd).get(arg_0);
                }
            }
        }
    }

    public static class Range
    extends ValuesSource {
        private final RangeType rangeType;
        protected final IndexFieldData<?> indexFieldData;

        public Range(IndexFieldData<?> indexFieldData, RangeType rangeType) {
            this.indexFieldData = indexFieldData;
            this.rangeType = rangeType;
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
            return this.indexFieldData.load(context).getBytesValues();
        }

        @Override
        public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
            SortedBinaryDocValues bytes = this.bytesValues(context);
            return FieldData.docsWithValue(bytes);
        }

        @Override
        public Function<Rounding, Rounding.Prepared> roundingPreparer(IndexReader reader) throws IOException {
            return Rounding::prepareForUnknown;
        }

        public RangeType rangeType() {
            return this.rangeType;
        }
    }
}

