/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.threadpool;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class ThreadPoolStats
implements Writeable,
ToXContentFragment,
Iterable<Stats> {
    private List<Stats> stats;

    public ThreadPoolStats(List<Stats> stats) {
        Collections.sort(stats);
        this.stats = stats;
    }

    public ThreadPoolStats(StreamInput in) throws IOException {
        this.stats = in.readList(Stats::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.stats);
    }

    @Override
    public Iterator<Stats> iterator() {
        return this.stats.iterator();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("thread_pool");
        for (Stats stat : this.stats) {
            stat.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String THREAD_POOL = "thread_pool";
        static final String THREADS = "threads";
        static final String QUEUE = "queue";
        static final String ACTIVE = "active";
        static final String REJECTED = "rejected";
        static final String LARGEST = "largest";
        static final String COMPLETED = "completed";

        Fields() {
        }
    }

    public static class Stats
    implements Writeable,
    ToXContentFragment,
    Comparable<Stats> {
        private final String name;
        private final int threads;
        private final int queue;
        private final int active;
        private final long rejected;
        private final int largest;
        private final long completed;

        public Stats(String name, int threads, int queue, int active, long rejected, int largest, long completed) {
            this.name = name;
            this.threads = threads;
            this.queue = queue;
            this.active = active;
            this.rejected = rejected;
            this.largest = largest;
            this.completed = completed;
        }

        public Stats(StreamInput in) throws IOException {
            this.name = in.readString();
            this.threads = in.readInt();
            this.queue = in.readInt();
            this.active = in.readInt();
            this.rejected = in.readLong();
            this.largest = in.readInt();
            this.completed = in.readLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeInt(this.threads);
            out.writeInt(this.queue);
            out.writeInt(this.active);
            out.writeLong(this.rejected);
            out.writeInt(this.largest);
            out.writeLong(this.completed);
        }

        public String getName() {
            return this.name;
        }

        public int getThreads() {
            return this.threads;
        }

        public int getQueue() {
            return this.queue;
        }

        public int getActive() {
            return this.active;
        }

        public long getRejected() {
            return this.rejected;
        }

        public int getLargest() {
            return this.largest;
        }

        public long getCompleted() {
            return this.completed;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.name);
            if (this.threads != -1) {
                builder.field("threads", this.threads);
            }
            if (this.queue != -1) {
                builder.field("queue", this.queue);
            }
            if (this.active != -1) {
                builder.field("active", this.active);
            }
            if (this.rejected != -1L) {
                builder.field("rejected", this.rejected);
            }
            if (this.largest != -1) {
                builder.field("largest", this.largest);
            }
            if (this.completed != -1L) {
                builder.field("completed", this.completed);
            }
            builder.endObject();
            return builder;
        }

        @Override
        public int compareTo(Stats other) {
            if (this.getName() == null && other.getName() == null) {
                return 0;
            }
            if (this.getName() != null && other.getName() == null) {
                return 1;
            }
            if (this.getName() == null) {
                return -1;
            }
            int compare = this.getName().compareTo(other.getName());
            if (compare == 0) {
                compare = Integer.compare(this.getThreads(), other.getThreads());
            }
            return compare;
        }
    }
}

