/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.image.formats;

import org.sunflow.image.Bitmap;
import org.sunflow.image.Color;

public class BitmapRGBE
extends Bitmap {
    private int w;
    private int h;
    private int[] data;
    private static final float[] EXPONENT = new float[256];

    public BitmapRGBE(int n, int n2, int[] nArray) {
        this.w = n;
        this.h = n2;
        this.data = nArray;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public Color readColor(int n, int n2) {
        int n3 = this.data[n + n2 * this.w];
        float f = EXPONENT[n3 & 0xFF];
        float f2 = f * ((float)(n3 >>> 24) + 0.5f);
        float f3 = f * ((float)(n3 >> 16 & 0xFF) + 0.5f);
        float f4 = f * ((float)(n3 >> 8 & 0xFF) + 0.5f);
        return new Color(f2, f3, f4);
    }

    public float readAlpha(int n, int n2) {
        return 1.0f;
    }

    static {
        BitmapRGBE.EXPONENT[0] = 0.0f;
        for (int i = 1; i < 256; ++i) {
            int n;
            float f = 1.0f;
            int n2 = i - 136;
            if (n2 > 0) {
                for (n = 0; n < n2; ++n) {
                    f *= 2.0f;
                }
            } else {
                for (n = 0; n < -n2; ++n) {
                    f *= 0.5f;
                }
            }
            BitmapRGBE.EXPONENT[i] = f;
        }
    }
}

