/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.charts.canvas;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.VolatileImage;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public abstract class BufferedCanvasComponent
extends JComponent {
    public static final int BUFFER_NONE = 0;
    public static final int BUFFER_IMAGE = 1;
    public static final int BUFFER_VOLATILE_IMAGE = 2;
    private static final int DEFAULT_BUFFER = Integer.getInteger("graphs.defaultBuffer", 2);
    private static final boolean ACCEL_DISABLED = true;
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private int bufferType = -1;
    private float accelerationPriority = 0.5f;
    private Image offscreenImage = null;
    private WeakReference<Image> offscreenImageReference = new WeakReference<Image>(this.offscreenImage);
    private Rectangle invalidOffscreenArea = new Rectangle();

    public BufferedCanvasComponent() {
        this(DEFAULT_BUFFER);
    }

    public BufferedCanvasComponent(int bufferType) {
        this.setOpaque(true);
        this.setBufferType(bufferType);
        this.addHierarchyListener(new VisibilityHandler());
    }

    protected abstract void paintComponent(Graphics var1, Rectangle var2);

    protected void reshaped(Rectangle oldBounds, Rectangle newBounds) {
        if (!oldBounds.getSize().equals(newBounds.getSize())) {
            this.releaseOffscreenImage();
        }
    }

    protected void shown() {
        this.invalidateImage();
        this.repaintDirty();
    }

    protected void hidden() {
        this.weaklyReleaseOffscreenImage();
    }

    protected void windowIconified() {
        this.hidden();
    }

    protected void windowDeiconified() {
        this.shown();
    }

    protected final void setBufferType(int bufferType) {
        if (this.bufferType == bufferType) {
            return;
        }
        if (bufferType != 0 && bufferType != 1 && bufferType != 2) {
            throw new IllegalArgumentException("Unknown buffer type: " + bufferType);
        }
        this.bufferType = bufferType;
        this.releaseOffscreenImage();
        this.repaintImpl(0, 0, this.getWidth(), this.getHeight());
    }

    protected final int getBufferType() {
        return this.bufferType;
    }

    protected final boolean isBuffered() {
        return this.bufferType != 0;
    }

    protected final void setAccelerationPriority(float priority) {
        this.accelerationPriority = priority;
        Image image = (Image)this.offscreenImageReference.get();
        if (image != null) {
            image.setAccelerationPriority(this.accelerationPriority);
        }
    }

    protected final float getAccelerationPriority() {
        return this.accelerationPriority;
    }

    protected final void releaseOffscreenImage() {
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
        }
        this.offscreenImage = null;
        this.offscreenImageReference.clear();
    }

    protected final void weaklyReleaseOffscreenImage() {
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
        }
        this.offscreenImage = null;
    }

    protected final void invalidateImage() {
        this.invalidOffscreenArea.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    protected final void invalidateImage(Rectangle invalidArea) {
        if (invalidArea.isEmpty()) {
            return;
        }
        this.addInvalidArea(invalidArea);
    }

    public final void repaintDirty() {
        if (!this.isDirty()) {
            return;
        }
        this.repaintImpl(0, 0, this.getWidth(), this.getHeight());
    }

    public final void repaintDirty(Rectangle dirtyArea) {
        this.addInvalidArea(dirtyArea);
        this.repaintImpl(this.invalidOffscreenArea.x, this.invalidOffscreenArea.y, this.invalidOffscreenArea.width, this.invalidOffscreenArea.height);
    }

    public final void repaintDirtyAccel() {
        if (!this.isDirty()) {
            return;
        }
        this.repaintImpl(0, 0, this.getWidth(), this.getHeight());
    }

    private void repaintImpl(int x, int y, int w, int h) {
        this.repaint(x, y, w, h);
    }

    boolean isDirty() {
        return !this.invalidOffscreenArea.isEmpty();
    }

    private void addInvalidArea(Rectangle invalidArea) {
        if (invalidArea.x > this.getWidth() || invalidArea.x + invalidArea.width < 0) {
            return;
        }
        if (invalidArea.y > this.getHeight() || invalidArea.y + invalidArea.height < 0) {
            return;
        }
        int origX = invalidArea.x;
        int origY = invalidArea.y;
        invalidArea.x = Math.max(invalidArea.x, 0);
        invalidArea.y = Math.max(invalidArea.y, 0);
        invalidArea.width = Math.min(origX + invalidArea.width, this.getWidth()) - invalidArea.x;
        invalidArea.height = Math.min(origY + invalidArea.height, this.getHeight()) - invalidArea.y;
        if (this.invalidOffscreenArea.isEmpty()) {
            this.invalidOffscreenArea.setBounds(invalidArea);
        } else {
            this.invalidOffscreenArea.add(invalidArea);
        }
    }

    @Override
    public final void paint(Graphics g) {
        super.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void paintComponent(Graphics g) {
        if (this.bufferType != 0) {
            int imageState = this.updateOffscreenImage();
            if (imageState == 2) {
                this.offscreenImage = this.createOffscreenImage();
                if (this.offscreenImage == null) {
                    return;
                }
                this.offscreenImage.setAccelerationPriority(this.accelerationPriority);
                this.offscreenImageReference = new WeakReference<Image>(this.offscreenImage);
                imageState = 1;
            }
            if (imageState == 1) {
                this.invalidOffscreenArea.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.isDirty()) {
                Graphics offscreenGraphics = this.offscreenImage.getGraphics();
                try {
                    this.paintComponent(offscreenGraphics, this.invalidOffscreenArea);
                }
                finally {
                    offscreenGraphics.dispose();
                }
            }
            g.drawImage(this.offscreenImage, 0, 0, null);
        } else {
            Rectangle clipRect = g.getClipBounds();
            if (clipRect == null) {
                clipRect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            }
            this.paintComponent(g, clipRect);
        }
        this.invalidOffscreenArea.setBounds(0, 0, 0, 0);
    }

    @Override
    protected final void paintChildren(Graphics g) {
        super.paintChildren(g);
    }

    @Override
    protected final void paintBorder(Graphics g) {
    }

    @Override
    public final void update(Graphics g) {
    }

    protected boolean canDirectlyAccessGraphics() {
        Container parent;
        if (this.getComponentCount() != 0) {
            return false;
        }
        if (!this.isOpaque()) {
            return false;
        }
        if (!(this.getParent() instanceof JComponent)) {
            return false;
        }
        if (!this.isShowing()) {
            return false;
        }
        Rectangle dirtyRegion = RepaintManager.currentManager(this).getDirtyRegion((JComponent)this.getParent());
        if (dirtyRegion != null && dirtyRegion.width > 0 && dirtyRegion.height > 0) {
            return false;
        }
        Rectangle clip = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        Rectangle oldClip = new Rectangle();
        Rectangle tmp2 = null;
        BufferedCanvasComponent lastParent = null;
        for (parent = this; parent != null && BufferedCanvasComponent.isLightweightComponent(parent); parent = parent.getParent()) {
            int x = ((Component)parent).getX();
            int y = ((Component)parent).getY();
            int w = ((Component)parent).getWidth();
            int h = ((Component)parent).getHeight();
            oldClip.setBounds(clip);
            SwingUtilities.computeIntersection(0, 0, w, h, clip);
            if (!clip.equals(oldClip)) {
                return false;
            }
            if (lastParent != null && parent instanceof JComponent && !((JComponent)parent).isOptimizedDrawingEnabled()) {
                Component[] comps = parent.getComponents();
                int index = 0;
                for (int i = comps.length - 1; i >= 0; --i) {
                    if (comps[i] != lastParent) continue;
                    index = i - 1;
                    break;
                }
                while (index >= 0) {
                    if ((tmp2 = comps[index].getBounds(tmp2)).intersects(clip)) {
                        return false;
                    }
                    --index;
                }
            }
            clip.x += x;
            clip.y += y;
            lastParent = parent;
        }
        return parent != null;
    }

    private Image createOffscreenImage() {
        switch (this.bufferType) {
            case 2: {
                if (this.offscreenImage != null) {
                    this.offscreenImage.flush();
                }
                return this.createVolatileImage(this.getWidth(), this.getHeight());
            }
            case 1: {
                if (this.offscreenImage != null) {
                    this.offscreenImage.flush();
                }
                return this.createImage(this.getWidth(), this.getHeight());
            }
        }
        return null;
    }

    private int updateOffscreenImage() {
        if (this.offscreenImage == null) {
            this.offscreenImage = (Image)this.offscreenImageReference.get();
        }
        if (this.offscreenImage == null) {
            return 2;
        }
        if (this.bufferType != 2) {
            return 0;
        }
        GraphicsConfiguration gConfiguration = this.getGraphicsConfiguration();
        if (gConfiguration == null) {
            return 2;
        }
        return ((VolatileImage)this.offscreenImage).validate(gConfiguration);
    }

    @Override
    public final void reshape(int x, int y, int w, int h) {
        Rectangle oldBounds = this.getBounds();
        Rectangle newBounds = new Rectangle(x, y, w, h);
        super.reshape(x, y, w, h);
        this.reshaped(oldBounds, newBounds);
    }

    @Override
    public final void setBorder(Border border) {
        if (border != null) {
            throw new IllegalArgumentException("setBorder() not supported");
        }
    }

    @Override
    public final Insets getInsets() {
        return ZERO_INSETS;
    }

    @Override
    public final Insets getInsets(Insets insets) {
        insets.set(0, 0, 0, 0);
        return insets;
    }

    private class VisibilityHandler
    extends WindowAdapter
    implements HierarchyListener {
        private Window lastParentWindow;

        private VisibilityHandler() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            Window parentWindow;
            if ((e.getChangeFlags() & 1L) != 0L && this.lastParentWindow != (parentWindow = SwingUtilities.getWindowAncestor(BufferedCanvasComponent.this))) {
                if (this.lastParentWindow != null) {
                    this.lastParentWindow.removeWindowListener(this);
                }
                if (parentWindow != null) {
                    parentWindow.addWindowListener(this);
                }
                this.lastParentWindow = parentWindow;
            }
            if ((e.getChangeFlags() & 4L) != 0L) {
                if (BufferedCanvasComponent.this.isShowing()) {
                    BufferedCanvasComponent.this.shown();
                } else {
                    BufferedCanvasComponent.this.hidden();
                }
            }
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            BufferedCanvasComponent.this.windowDeiconified();
        }

        @Override
        public void windowIconified(WindowEvent e) {
            BufferedCanvasComponent.this.windowIconified();
        }
    }
}

