/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.project.api.Project;
import org.gephi.project.api.Projects;
import org.gephi.project.impl.ProjectImpl;
import org.gephi.project.io.SaveTask;
import org.openide.util.NbBundle;

public class ProjectsImpl
implements Projects {
    private final List<ProjectImpl> projects = new ArrayList<ProjectImpl>();
    private ProjectImpl currentProject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProject(ProjectImpl project) {
        List<ProjectImpl> list = this.projects;
        synchronized (list) {
            if (this.projects.contains(project)) {
                throw new IllegalArgumentException("The project " + project.getUniqueIdentifier() + " already exists");
            }
            this.projects.add(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsProject(Project project) {
        List<ProjectImpl> list = this.projects;
        synchronized (list) {
            return this.projects.contains(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectImpl getProjectByIdentifier(String identifier) {
        List<ProjectImpl> list = this.projects;
        synchronized (list) {
            for (Project project : this.projects) {
                if (!project.getUniqueIdentifier().equals(identifier)) continue;
                return (ProjectImpl)project;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrReplaceProject(ProjectImpl project) {
        List<ProjectImpl> list = this.projects;
        synchronized (list) {
            if (this.projects.contains(project)) {
                this.projects.remove(project);
                this.projects.add(project);
            } else {
                ProjectImpl projectWithSameFileName = this.findProjectByFile(project.getFile());
                if (projectWithSameFileName != null && projectWithSameFileName != project) {
                    this.projects.remove(projectWithSameFileName);
                }
                this.projects.add(project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectImpl findProjectByFile(File file) {
        if (file != null) {
            List<ProjectImpl> list = this.projects;
            synchronized (list) {
                for (ProjectImpl p : this.projects) {
                    if (p.getFile() == null || !p.getFile().equals(file)) continue;
                    return p;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProject(ProjectImpl project) {
        List<ProjectImpl> list = this.projects;
        synchronized (list) {
            this.projects.remove(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectImpl[] getProjects() {
        List<ProjectImpl> list = this.projects;
        synchronized (list) {
            Object[] res = this.projects.toArray(new ProjectImpl[0]);
            Arrays.sort(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectImpl getCurrentProject() {
        List<ProjectImpl> list = this.projects;
        synchronized (list) {
            return this.currentProject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentProject(ProjectImpl currentProject) {
        List<ProjectImpl> list = this.projects;
        synchronized (list) {
            this.currentProject = currentProject;
            if (currentProject != null) {
                currentProject.open();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasCurrentProject() {
        List<ProjectImpl> list = this.projects;
        synchronized (list) {
            return this.currentProject != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCurrentProject() {
        List<ProjectImpl> list = this.projects;
        synchronized (list) {
            if (this.currentProject != null) {
                this.currentProject.close();
            }
            this.currentProject = null;
        }
    }

    protected String nextUntitledProjectName() {
        int i = 0;
        while (true) {
            String name = NbBundle.getMessage(ProjectImpl.class, (String)"Project.default.prefix") + (String)(i > 0 ? " " + i : "");
            if (this.projects.stream().noneMatch(p -> p.getName().equals(name))) {
                return name;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveProjects(File file) throws IOException {
        List<ProjectImpl> list = this.projects;
        synchronized (list) {
            try (FileOutputStream fos = new FileOutputStream(file);){
                XMLStreamWriter writer = SaveTask.newXMLWriter(fos);
                writer.writeStartDocument("UTF-8", "1.0");
                writer.writeStartElement("projects");
                for (ProjectImpl p : this.getProjects()) {
                    if (!p.hasFile() && p.isOpen() || p.hasFile() && p.getFile().exists()) {
                        writer.writeStartElement("project");
                        if (p.hasFile()) {
                            writer.writeAttribute("file", p.getFile().getAbsolutePath());
                        }
                        writer.writeAttribute("id", p.getUniqueIdentifier());
                        writer.writeAttribute("name", p.getName());
                        if (p.getLastOpened() != null) {
                            writer.writeAttribute("lastOpened", String.valueOf(p.getLastOpened().toEpochMilli()));
                        }
                        writer.writeEndElement();
                        continue;
                    }
                    if (!p.hasFile()) continue;
                    Logger.getLogger(ProjectsImpl.class.getName()).warning("Project " + p.getName() + " file does not exist");
                }
                writer.writeEndDocument();
            }
            catch (XMLStreamException ex) {
                throw new IOException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadProjects(File file) throws IOException {
        List<ProjectImpl> list = this.projects;
        synchronized (list) {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            if (inputFactory.isPropertySupported("javax.xml.stream.isValidating")) {
                inputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            }
            try (FileInputStream fis = new FileInputStream(file);){
                XMLStreamReader reader = inputFactory.createXMLStreamReader(fis, "UTF-8");
                boolean end = false;
                while (reader.hasNext() && !end) {
                    int type = reader.next();
                    switch (type) {
                        case 1: {
                            String name = reader.getLocalName();
                            if (!"project".equalsIgnoreCase(name)) break;
                            String filePath = reader.getAttributeValue(null, "file");
                            String id = reader.getAttributeValue(null, "id");
                            String projectName = reader.getAttributeValue(null, "name");
                            String lastOpened = reader.getAttributeValue(null, "lastOpened");
                            if (filePath == null || new File(filePath).exists()) {
                                ProjectImpl project = new ProjectImpl(id, projectName);
                                if (filePath != null) {
                                    project.setFile(new File(filePath));
                                }
                                if (lastOpened != null) {
                                    project.setLastOpened(Instant.ofEpochMilli(Long.parseLong(lastOpened)));
                                }
                                this.addOrReplaceProject(project);
                                break;
                            }
                            Logger.getLogger(ProjectsImpl.class.getName()).warning("Project " + projectName + " file does not exist");
                            break;
                        }
                        case 2: {
                            if (!"projects".equalsIgnoreCase(reader.getLocalName())) break;
                            end = true;
                        }
                    }
                }
                reader.close();
            }
            catch (XMLStreamException ex) {
                throw new IOException(ex);
            }
        }
    }
}

