/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.symbol;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.painless.MethodWriter;
import org.opensearch.painless.lookup.PainlessLookupUtility;
import org.opensearch.repackage.org.objectweb.asm.Type;

public class WriteScope {
    protected final WriteScope parent;
    protected final Map<String, Variable> variables = new HashMap<String, Variable>();
    protected int nextSlot;

    public WriteScope() {
        this.parent = null;
        this.nextSlot = 0;
    }

    protected WriteScope(WriteScope parent, int nextSlot) {
        this.parent = parent;
        this.nextSlot = nextSlot;
    }

    public WriteScope newScope() {
        return new WriteScope(this, this.nextSlot);
    }

    public Variable defineVariable(Class<?> type, String name) {
        Variable variable = new Variable(type, name, this.nextSlot);
        this.nextSlot += variable.getAsmType().getSize();
        this.variables.put(name, variable);
        return variable;
    }

    public Variable defineInternalVariable(Class<?> type, String name) {
        return this.defineVariable(type, "#" + name);
    }

    public Variable getVariable(String name) {
        Variable variable = this.variables.get(name);
        if (variable == null && this.parent != null) {
            variable = this.parent.getVariable(name);
        }
        return variable;
    }

    public Variable getInternalVariable(String name) {
        return this.getVariable("#" + name);
    }

    public static class Variable {
        protected final Class<?> type;
        protected final Type asmType;
        protected final String name;
        protected final int slot;

        public Variable(Class<?> type, String name, int slot) {
            this.type = type;
            this.asmType = MethodWriter.getType(type);
            this.name = name;
            this.slot = slot;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getCanonicalTypeName() {
            return PainlessLookupUtility.typeToCanonicalTypeName(this.type);
        }

        public Type getAsmType() {
            return this.asmType;
        }

        public String getName() {
            return this.name;
        }

        public int getSlot() {
            return this.slot;
        }
    }
}

