/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.template.get;

import java.io.IOException;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeReadRequest;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.common.Strings;

public class GetIndexTemplatesRequest
extends ClusterManagerNodeReadRequest<GetIndexTemplatesRequest> {
    private String[] names;

    public GetIndexTemplatesRequest() {
    }

    public GetIndexTemplatesRequest(String ... names) {
        this.names = names;
    }

    public GetIndexTemplatesRequest(StreamInput in) throws IOException {
        super(in);
        this.names = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.names);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.names == null) {
            validationException = ValidateActions.addValidationError("names is null or empty", validationException);
        } else {
            for (String name : this.names) {
                if (name != null && Strings.hasText((String)name)) continue;
                validationException = ValidateActions.addValidationError("name is missing", validationException);
            }
        }
        return validationException;
    }

    public GetIndexTemplatesRequest names(String ... names) {
        this.names = names;
        return this;
    }

    public String[] names() {
        return this.names;
    }
}

