/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.Set;
import java.util.function.BiFunction;
import org.opensearch.action.ActionListener;
import org.opensearch.action.StepListener;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.transport.RemoteClusterService;

public class SearchUtils {
    public static ActionListener<BiFunction<String, String, DiscoveryNode>> getConnectionLookupListener(RemoteClusterService remoteClusterService, ClusterState state, Set<String> clusters) {
        StepListener<BiFunction<String, String, DiscoveryNode>> lookupListener = new StepListener<BiFunction<String, String, DiscoveryNode>>();
        if (clusters.isEmpty()) {
            lookupListener.onResponse((cluster, nodeId) -> state.getNodes().get((String)nodeId));
        } else {
            remoteClusterService.collectNodes(clusters, lookupListener);
        }
        return lookupListener;
    }
}

