/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.opensearch.action.ActionListener;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.DeleteResult;

public interface BlobContainer {
    public BlobPath path();

    public boolean blobExists(String var1) throws IOException;

    public InputStream readBlob(String var1) throws IOException;

    public InputStream readBlob(String var1, long var2, long var4) throws IOException;

    default public long readBlobPreferredLength() {
        throw new UnsupportedOperationException();
    }

    public void writeBlob(String var1, InputStream var2, long var3, boolean var5) throws IOException;

    public void writeBlobAtomic(String var1, InputStream var2, long var3, boolean var5) throws IOException;

    public DeleteResult delete() throws IOException;

    public void deleteBlobsIgnoringIfNotExists(List<String> var1) throws IOException;

    public Map<String, BlobMetadata> listBlobs() throws IOException;

    public Map<String, BlobContainer> children() throws IOException;

    public Map<String, BlobMetadata> listBlobsByPrefix(String var1) throws IOException;

    default public void listBlobsByPrefixInSortedOrder(String blobNamePrefix, int limit, BlobNameSortOrder blobNameSortOrder, ActionListener<List<BlobMetadata>> listener) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit should not be a negative value");
        }
        try {
            ArrayList<BlobMetadata> blobNames = new ArrayList<BlobMetadata>(this.listBlobsByPrefix(blobNamePrefix).values());
            blobNames.sort(blobNameSortOrder.comparator());
            listener.onResponse(blobNames.subList(0, Math.min(blobNames.size(), limit)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public static enum BlobNameSortOrder {
        LEXICOGRAPHIC(Comparator.comparing(BlobMetadata::name));

        final Comparator<BlobMetadata> comparator;

        public Comparator<BlobMetadata> comparator() {
            return this.comparator;
        }

        private BlobNameSortOrder(Comparator<BlobMetadata> comparator) {
            this.comparator = comparator;
        }
    }
}

