/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.bytes;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.concurrent.RefCountedReleasable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.lease.Releasable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public final class ReleasableBytesReference
implements Releasable,
BytesReference {
    public static final Releasable NO_OP = () -> {};
    private final BytesReference delegate;
    private final RefCountedReleasable<Releasable> refCounted;

    public ReleasableBytesReference(BytesReference delegate, Releasable releasable) {
        this.delegate = delegate;
        this.refCounted = new RefCountedReleasable<Releasable>("bytes-reference", releasable, () -> ((Releasable)releasable).close());
    }

    private ReleasableBytesReference(BytesReference delegate, RefCountedReleasable<Releasable> refCounted) {
        this.delegate = delegate;
        this.refCounted = refCounted;
        refCounted.incRef();
    }

    public static ReleasableBytesReference wrap(BytesReference reference) {
        return new ReleasableBytesReference(reference, NO_OP);
    }

    public int refCount() {
        return this.refCounted.refCount();
    }

    public ReleasableBytesReference retain() {
        this.refCounted.incRef();
        return this;
    }

    public ReleasableBytesReference retainedSlice(int from, int length) {
        return new ReleasableBytesReference(this.delegate.slice(from, length), this.refCounted);
    }

    public void close() {
        this.refCounted.close();
    }

    public byte get(int index) {
        return this.delegate.get(index);
    }

    public int getInt(int index) {
        return this.delegate.getInt(index);
    }

    public int indexOf(byte marker, int from) {
        return this.delegate.indexOf(marker, from);
    }

    public int length() {
        return this.delegate.length();
    }

    public BytesReference slice(int from, int length) {
        return this.delegate.slice(from, length);
    }

    public long ramBytesUsed() {
        return this.delegate.ramBytesUsed();
    }

    public StreamInput streamInput() throws IOException {
        return this.delegate.streamInput();
    }

    public void writeTo(OutputStream os) throws IOException {
        this.delegate.writeTo(os);
    }

    public String utf8ToString() {
        return this.delegate.utf8ToString();
    }

    public BytesRef toBytesRef() {
        return this.delegate.toBytesRef();
    }

    public BytesRefIterator iterator() {
        return this.delegate.iterator();
    }

    public int compareTo(BytesReference o) {
        return this.delegate.compareTo((Object)o);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.delegate.toXContent(builder, params);
    }

    public boolean isFragment() {
        return this.delegate.isFragment();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

