/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.metrics;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class OperationStats
implements Writeable,
ToXContentFragment {
    private final long count;
    private final long totalTimeInMillis;
    private final long current;
    private final long failedCount;

    public OperationStats(long count, long totalTimeInMillis, long current, long failedCount) {
        this.count = count;
        this.totalTimeInMillis = totalTimeInMillis;
        this.current = current;
        this.failedCount = failedCount;
    }

    public OperationStats(StreamInput in) throws IOException {
        this.count = in.readVLong();
        this.totalTimeInMillis = in.readVLong();
        this.current = in.readVLong();
        this.failedCount = in.readVLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        out.writeVLong(this.totalTimeInMillis);
        out.writeVLong(this.current);
        out.writeVLong(this.failedCount);
    }

    public long getCount() {
        return this.count;
    }

    public long getTotalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public long getCurrent() {
        return this.current;
    }

    public long getFailedCount() {
        return this.failedCount;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field("count", this.count).humanReadableField("time_in_millis", "time", (Object)new TimeValue(this.totalTimeInMillis, TimeUnit.MILLISECONDS)).field("current", this.current).field("failed", this.failedCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationStats that = (OperationStats)o;
        return Objects.equals(this.count, that.count) && Objects.equals(this.totalTimeInMillis, that.totalTimeInMillis) && Objects.equals(this.failedCount, that.failedCount) && Objects.equals(this.current, that.current);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.totalTimeInMillis, this.failedCount, this.current);
    }
}

