/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.env;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.settings.Settings;
import org.opensearch.transport.TransportResponse;

public class EnvironmentSettingsResponse
extends TransportResponse {
    private final Settings environmentSettings;

    public EnvironmentSettingsResponse(Settings environmentSettings) {
        this.environmentSettings = environmentSettings;
    }

    public EnvironmentSettingsResponse(StreamInput in) throws IOException {
        this.environmentSettings = Settings.readSettingsFromStream(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Settings.writeSettingsToStream(this.environmentSettings, out);
    }

    public Settings getEnvironmentSettings() {
        return this.environmentSettings;
    }

    public String toString() {
        return "EnvironmentSettingsResponse{environmentSettings=" + this.environmentSettings.toString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentSettingsResponse that = (EnvironmentSettingsResponse)o;
        return Objects.equals(this.environmentSettings, that.environmentSettings);
    }

    public int hashCode() {
        return Objects.hash(this.environmentSettings);
    }
}

