/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http;

import java.util.List;
import java.util.Map;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.http.HttpPipelinedMessage;
import org.opensearch.http.HttpPipelinedResponse;
import org.opensearch.http.HttpRequest;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestStatus;

public class HttpPipelinedRequest
implements HttpRequest,
HttpPipelinedMessage {
    private final int sequence;
    private final HttpRequest delegate;

    public HttpPipelinedRequest(int sequence, HttpRequest delegate) {
        this.sequence = sequence;
        this.delegate = delegate;
    }

    @Override
    public RestRequest.Method method() {
        return this.delegate.method();
    }

    @Override
    public String uri() {
        return this.delegate.uri();
    }

    @Override
    public BytesReference content() {
        return this.delegate.content();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.delegate.getHeaders();
    }

    @Override
    public List<String> strictCookies() {
        return this.delegate.strictCookies();
    }

    @Override
    public HttpRequest.HttpVersion protocolVersion() {
        return this.delegate.protocolVersion();
    }

    @Override
    public HttpRequest removeHeader(String header) {
        return this.delegate.removeHeader(header);
    }

    @Override
    public HttpPipelinedResponse createResponse(RestStatus status, BytesReference content) {
        return new HttpPipelinedResponse(this.sequence, this.delegate.createResponse(status, content));
    }

    @Override
    public void release() {
        this.delegate.release();
    }

    @Override
    public HttpRequest releaseAndCopy() {
        return this.delegate.releaseAndCopy();
    }

    @Override
    public Exception getInboundException() {
        return this.delegate.getInboundException();
    }

    @Override
    public int getSequence() {
        return this.sequence;
    }

    public HttpRequest getDelegateRequest() {
        return this.delegate;
    }
}

