/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.SegmentReplicationPerGroupStats;
import org.opensearch.index.shard.ShardId;

public class SegmentReplicationStats
implements Writeable,
ToXContentFragment {
    private final Map<ShardId, SegmentReplicationPerGroupStats> shardStats;

    public SegmentReplicationStats(Map<ShardId, SegmentReplicationPerGroupStats> shardStats) {
        this.shardStats = shardStats;
    }

    public SegmentReplicationStats(StreamInput in) throws IOException {
        int shardEntries = in.readInt();
        this.shardStats = new HashMap<ShardId, SegmentReplicationPerGroupStats>();
        for (int i = 0; i < shardEntries; ++i) {
            ShardId shardId = new ShardId(in);
            SegmentReplicationPerGroupStats groupStats = new SegmentReplicationPerGroupStats(in);
            this.shardStats.put(shardId, groupStats);
        }
    }

    public Map<ShardId, SegmentReplicationPerGroupStats> getShardStats() {
        return this.shardStats;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("segment_replication");
        for (Map.Entry<ShardId, SegmentReplicationPerGroupStats> entry : this.shardStats.entrySet()) {
            builder.startObject(entry.getKey().toString());
            entry.getValue().toXContent(builder, params);
            builder.endObject();
        }
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.shardStats.size());
        for (Map.Entry<ShardId, SegmentReplicationPerGroupStats> entry : this.shardStats.entrySet()) {
            entry.getKey().writeTo(out);
            entry.getValue().writeTo(out);
        }
    }

    public String toString() {
        return "SegmentReplicationStats{shardStats=" + this.shardStats + "}";
    }
}

