/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.opensearch.action.ActionListener;
import org.opensearch.action.LatchedActionListener;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.index.store.RemoteIndexInput;
import org.opensearch.index.store.RemoteIndexOutput;

public class RemoteDirectory
extends Directory {
    protected final BlobContainer blobContainer;

    public RemoteDirectory(BlobContainer blobContainer) {
        this.blobContainer = blobContainer;
    }

    public String[] listAll() throws IOException {
        return (String[])this.blobContainer.listBlobs().keySet().stream().sorted().toArray(String[]::new);
    }

    public Collection<String> listFilesByPrefix(String filenamePrefix) throws IOException {
        return this.blobContainer.listBlobsByPrefix(filenamePrefix).keySet();
    }

    public List<String> listFilesByPrefixInLexicographicOrder(String filenamePrefix, int limit) throws IOException {
        final ArrayList<String> sortedBlobList = new ArrayList<String>();
        final AtomicReference exception = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        LatchedActionListener<List<BlobMetadata>> actionListener = new LatchedActionListener<List<BlobMetadata>>(new ActionListener<List<BlobMetadata>>(){

            @Override
            public void onResponse(List<BlobMetadata> blobMetadata) {
                sortedBlobList.addAll(blobMetadata.stream().map(BlobMetadata::name).collect(Collectors.toList()));
            }

            @Override
            public void onFailure(Exception e) {
                exception.set(e);
            }
        }, latch);
        try {
            this.blobContainer.listBlobsByPrefixInSortedOrder(filenamePrefix, limit, BlobContainer.BlobNameSortOrder.LEXICOGRAPHIC, actionListener);
            latch.await();
        }
        catch (InterruptedException e) {
            throw new IOException("Exception in listFilesByPrefixInLexicographicOrder with prefix: " + filenamePrefix, e);
        }
        if (exception.get() != null) {
            throw new IOException((Throwable)exception.get());
        }
        return sortedBlobList;
    }

    public void deleteFile(String name) throws IOException {
        this.blobContainer.deleteBlobsIgnoringIfNotExists(Collections.singletonList(name));
    }

    public IndexOutput createOutput(String name, IOContext context) {
        return new RemoteIndexOutput(name, this.blobContainer);
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.blobContainer.readBlob(name);
            return new RemoteIndexInput(name, inputStream, this.fileLength(name));
        }
        catch (Exception e) {
            if (inputStream != null) {
                inputStream.close();
            }
            throw e;
        }
    }

    public void close() throws IOException {
    }

    public long fileLength(String name) throws IOException {
        Map<String, BlobMetadata> metadata = this.blobContainer.listBlobsByPrefix(name);
        if (metadata.containsKey(name)) {
            return metadata.get(name).length();
        }
        throw new NoSuchFileException(name);
    }

    public Set<String> getPendingDeletions() throws IOException {
        throw new UnsupportedOperationException();
    }

    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) {
        throw new UnsupportedOperationException();
    }

    public void sync(Collection<String> names) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void syncMetaData() {
        throw new UnsupportedOperationException();
    }

    public void rename(String source, String dest) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Lock obtainLock(String name) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void delete() throws IOException {
        this.blobContainer.delete();
    }
}

