/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.flush.FlushRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.UUIDs;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.util.CancellableThreads;
import org.opensearch.core.Assertions;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.mapper.MapperException;
import org.opensearch.index.seqno.ReplicationTracker;
import org.opensearch.index.seqno.RetentionLeases;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardNotRecoveringException;
import org.opensearch.index.shard.IndexShardState;
import org.opensearch.index.store.Store;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.index.translog.Translog;
import org.opensearch.indices.recovery.MultiFileWriter;
import org.opensearch.indices.recovery.RecoveryFailedException;
import org.opensearch.indices.recovery.RecoveryState;
import org.opensearch.indices.recovery.RecoveryTargetHandler;
import org.opensearch.indices.replication.common.ReplicationFailedException;
import org.opensearch.indices.replication.common.ReplicationListener;
import org.opensearch.indices.replication.common.ReplicationLuceneIndex;
import org.opensearch.indices.replication.common.ReplicationTarget;

public class RecoveryTarget
extends ReplicationTarget
implements RecoveryTargetHandler {
    private static final String RECOVERY_PREFIX = "recovery.";
    private final DiscoveryNode sourceNode;
    protected final MultiFileWriter multiFileWriter;
    private final CountDownLatch closedLatch = new CountDownLatch(1);

    public RecoveryTarget(IndexShard indexShard, DiscoveryNode sourceNode, ReplicationListener listener) {
        super("recovery_status", indexShard, indexShard.recoveryState().getIndex(), listener);
        this.sourceNode = sourceNode;
        indexShard.recoveryStats().incCurrentAsTarget();
        String tempFilePrefix = this.getPrefix() + UUIDs.randomBase64UUID() + ".";
        this.multiFileWriter = new MultiFileWriter(indexShard.store(), this.stateIndex, tempFilePrefix, this.logger, this::ensureRefCount);
    }

    @Override
    public RecoveryTarget retryCopy() {
        return new RecoveryTarget(this.indexShard, this.sourceNode, this.listener);
    }

    public String source() {
        return this.sourceNode.toString();
    }

    public DiscoveryNode sourceNode() {
        return this.sourceNode;
    }

    @Override
    public RecoveryState state() {
        return this.indexShard.recoveryState();
    }

    @Override
    public CancellableThreads cancellableThreads() {
        return this.cancellableThreads;
    }

    @Override
    public String description() {
        return "recovery from " + this.source();
    }

    @Override
    public void notifyListener(ReplicationFailedException e, boolean sendShardFailure) {
        this.listener.onFailure(this.state(), new RecoveryFailedException(this.state(), e.getMessage(), (Throwable)((Object)e)), sendShardFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reset(CancellableThreads newTargetCancellableThreads) throws IOException {
        long recoveryId = this.getId();
        if (this.finished.compareAndSet(false, true)) {
            try {
                this.logger.debug("reset of recovery with shard {} and id [{}]", (Object)this.shardId(), (Object)recoveryId);
            }
            finally {
                this.decRef();
            }
            try {
                newTargetCancellableThreads.execute(this.closedLatch::await);
            }
            catch (CancellableThreads.ExecutionCancelledException e) {
                this.logger.trace("new recovery target cancelled for shard {} while waiting on old recovery target with id [{}] to close", (Object)this.shardId(), (Object)recoveryId);
                return false;
            }
            RecoveryState.Stage stage = this.indexShard.recoveryState().getStage();
            if (this.indexShard.recoveryState().getPrimary() && (stage == RecoveryState.Stage.FINALIZE || stage == RecoveryState.Stage.DONE)) {
                assert (stage != RecoveryState.Stage.DONE) : "recovery should not have completed when it's being reset";
                throw new IllegalStateException("cannot reset recovery as previous attempt made it past finalization step");
            }
            this.indexShard.performRecoveryRestart();
            return true;
        }
        return false;
    }

    @Override
    public void cancel(String reason) {
        if (this.finished.compareAndSet(false, true)) {
            try {
                this.logger.debug("recovery canceled (reason: [{}])", (Object)reason);
                this.cancellableThreads.cancel(reason);
            }
            finally {
                this.decRef();
            }
        }
    }

    public void fail(RecoveryFailedException e, boolean sendShardFailure) {
        super.fail(e, sendShardFailure);
    }

    @Override
    public void markAsDone() {
        if (this.finished.compareAndSet(false, true)) {
            assert (this.multiFileWriter.tempFileNames.isEmpty()) : "not all temporary files are renamed";
            try {
                this.indexShard.postRecovery("peer recovery done");
            }
            finally {
                this.decRef();
            }
            this.listener.onDone(this.state());
        }
    }

    @Override
    protected void closeInternal() {
        try {
            this.multiFileWriter.close();
        }
        finally {
            this.store.decRef();
            this.indexShard.recoveryStats().decCurrentAsTarget();
            this.closedLatch.countDown();
        }
    }

    public String toString() {
        return this.shardId() + " [" + this.getId() + "]";
    }

    @Override
    protected String getPrefix() {
        return RECOVERY_PREFIX;
    }

    @Override
    protected void onDone() {
        assert (this.multiFileWriter.tempFileNames.isEmpty()) : "not all temporary files are renamed";
        this.indexShard.postRecovery("peer recovery done");
    }

    @Override
    public void prepareForTranslogOperations(int totalTranslogOps, ActionListener<Void> listener) {
        ActionListener.completeWith(listener, () -> {
            this.state().getIndex().setFileDetailsComplete();
            this.state().getTranslog().totalOperations(totalTranslogOps);
            this.indexShard().openEngineAndSkipTranslogRecovery();
            return null;
        });
    }

    @Override
    public void forceSegmentFileSync() {
        throw new UnsupportedOperationException("Method not supported on target!");
    }

    @Override
    public void finalizeRecovery(long globalCheckpoint, long trimAboveSeqNo, ActionListener<Void> listener) {
        ActionListener.completeWith(listener, () -> {
            this.indexShard.updateGlobalCheckpointOnReplica(globalCheckpoint, "finalizing recovery");
            this.indexShard.sync();
            this.indexShard.persistRetentionLeases();
            if (trimAboveSeqNo != -2L) {
                this.indexShard.rollTranslogGeneration();
                this.indexShard.afterWriteOperation();
                this.indexShard.trimOperationOfPreviousPrimaryTerms(trimAboveSeqNo);
            }
            if (this.hasUncommittedOperations()) {
                this.indexShard.flush(new FlushRequest(new String[0]).force(true).waitIfOngoing(true));
            }
            this.indexShard.finalizeRecovery();
            return null;
        });
    }

    private boolean hasUncommittedOperations() throws IOException {
        long localCheckpointOfCommit = Long.parseLong(this.indexShard.commitStats().getUserData().get("local_checkpoint"));
        return this.indexShard.countNumberOfHistoryOperations("peer-recovery", localCheckpointOfCommit + 1L, Long.MAX_VALUE) > 0;
    }

    @Override
    public void handoffPrimaryContext(ReplicationTracker.PrimaryContext primaryContext) {
        this.indexShard.activateWithPrimaryContext(primaryContext);
    }

    @Override
    public void indexTranslogOperations(List<Translog.Operation> operations, int totalTranslogOps, long maxSeenAutoIdTimestampOnPrimary, long maxSeqNoOfDeletesOrUpdatesOnPrimary, RetentionLeases retentionLeases, long mappingVersionOnPrimary, ActionListener<Long> listener) {
        ActionListener.completeWith(listener, () -> {
            RecoveryState.Translog translog = this.state().getTranslog();
            translog.totalOperations(totalTranslogOps);
            assert (this.indexShard().recoveryState() == this.state());
            if (this.indexShard().state() != IndexShardState.RECOVERING) {
                throw new IndexShardNotRecoveringException(this.shardId(), this.indexShard().state());
            }
            this.indexShard().updateMaxUnsafeAutoIdTimestamp(maxSeenAutoIdTimestampOnPrimary);
            this.indexShard().advanceMaxSeqNoOfUpdatesOrDeletes(maxSeqNoOfDeletesOrUpdatesOnPrimary);
            this.indexShard().updateRetentionLeasesOnReplica(retentionLeases);
            for (Translog.Operation operation : operations) {
                Engine.Result result = this.indexShard().applyTranslogOperation(operation, Engine.Operation.Origin.PEER_RECOVERY);
                if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                    throw new MapperException("mapping updates are not allowed [" + operation + "]");
                }
                if (result.getFailure() == null) continue;
                if (Assertions.ENABLED && !(result.getFailure() instanceof MapperException)) {
                    throw new AssertionError("unexpected failure while replicating translog entry", result.getFailure());
                }
                ExceptionsHelper.reThrowIfNotNull((Throwable)result.getFailure());
            }
            translog.incrementRecoveredOperations(operations.size());
            this.indexShard().sync();
            this.indexShard().afterWriteOperation();
            return this.indexShard().getLocalCheckpoint();
        });
    }

    @Override
    public void receiveFileInfo(List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, int totalTranslogOps, ActionListener<Void> listener) {
        ActionListener.completeWith(listener, () -> {
            int i;
            this.indexShard.resetRecoveryStage();
            this.indexShard.prepareForIndexRecovery();
            ReplicationLuceneIndex index = this.state().getIndex();
            for (i = 0; i < phase1ExistingFileNames.size(); ++i) {
                index.addFileDetail((String)phase1ExistingFileNames.get(i), (Long)phase1ExistingFileSizes.get(i), true);
            }
            for (i = 0; i < phase1FileNames.size(); ++i) {
                index.addFileDetail((String)phase1FileNames.get(i), (Long)phase1FileSizes.get(i), false);
            }
            index.setFileDetailsComplete();
            this.state().getTranslog().totalOperations(totalTranslogOps);
            this.state().getTranslog().totalOperationsOnStart(totalTranslogOps);
            return null;
        });
    }

    @Override
    public void cleanFiles(int totalTranslogOps, long globalCheckpoint, Store.MetadataSnapshot sourceMetadata, ActionListener<Void> listener) {
        ActionListener.completeWith(listener, () -> {
            this.state().getTranslog().totalOperations(totalTranslogOps);
            this.multiFileWriter.renameAllTempFiles();
            Store store = this.store();
            store.incRef();
            try {
                boolean reuseTranslogUUID;
                store.cleanupAndVerify("recovery CleanFilesRequestHandler", sourceMetadata);
                boolean bl = reuseTranslogUUID = this.indexShard.indexSettings().isSegRepEnabled() || this.indexShard.indexSettings().isRemoteSnapshot();
                if (reuseTranslogUUID) {
                    String translogUUID = store.getMetadata().getCommitUserData().get("translog_uuid");
                    Translog.createEmptyTranslog(this.indexShard.shardPath().resolveTranslog(), this.shardId(), globalCheckpoint, this.indexShard.getPendingPrimaryTerm(), translogUUID, FileChannel::open);
                } else {
                    String translogUUID = Translog.createEmptyTranslog(this.indexShard.shardPath().resolveTranslog(), globalCheckpoint, this.shardId(), this.indexShard.getPendingPrimaryTerm());
                    store.associateIndexWithNewTranslog(translogUUID);
                }
                if (this.indexShard.getRetentionLeases().leases().isEmpty()) {
                    this.indexShard.persistRetentionLeases();
                    assert (this.indexShard.loadRetentionLeases().leases().isEmpty());
                } else assert (this.indexShard.assertRetentionLeasesPersisted());
                this.indexShard.maybeCheckIndex();
                this.state().setStage(RecoveryState.Stage.TRANSLOG);
            }
            catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                try {
                    try {
                        store.removeCorruptionMarker();
                    }
                    finally {
                        Lucene.cleanLuceneIndex(store.directory());
                    }
                }
                catch (Exception e) {
                    this.logger.debug("Failed to clean lucene index", (Throwable)e);
                    ex.addSuppressed(e);
                }
                RecoveryFailedException rfe = new RecoveryFailedException(this.state(), "failed to clean after recovery", ex);
                this.fail(rfe, true);
                throw rfe;
            }
            catch (Exception ex) {
                RecoveryFailedException rfe = new RecoveryFailedException(this.state(), "failed to clean after recovery", (Throwable)ex);
                this.fail(rfe, true);
                throw rfe;
            }
            finally {
                store.decRef();
            }
            return null;
        });
    }

    @Override
    public void writeFileChunk(StoreFileMetadata fileMetadata, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        try {
            this.state().getTranslog().totalOperations(totalTranslogOps);
            this.multiFileWriter.writeFileChunk(fileMetadata, position, content, lastChunk);
            listener.onResponse(null);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public String getTempNameForFile(String origFile) {
        return this.multiFileWriter.getTempNameForFile(origFile);
    }

    Path translogLocation() {
        return this.indexShard().shardPath().resolveTranslog();
    }
}

