/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardId;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.indices.replication.PrimaryShardReplicationSource;
import org.opensearch.indices.replication.RemoteStoreReplicationSource;
import org.opensearch.indices.replication.SegmentReplicationSource;
import org.opensearch.transport.TransportService;

public class SegmentReplicationSourceFactory {
    private final TransportService transportService;
    private final RecoverySettings recoverySettings;
    private final ClusterService clusterService;

    public SegmentReplicationSourceFactory(TransportService transportService, RecoverySettings recoverySettings, ClusterService clusterService) {
        this.transportService = transportService;
        this.recoverySettings = recoverySettings;
        this.clusterService = clusterService;
    }

    public SegmentReplicationSource get(IndexShard shard) {
        if (shard.indexSettings().isSegRepWithRemoteEnabled()) {
            return new RemoteStoreReplicationSource(shard);
        }
        return new PrimaryShardReplicationSource(shard.recoveryState().getTargetNode(), shard.routingEntry().allocationId().getId(), this.transportService, this.recoverySettings, this.getPrimaryNode(shard.shardId()));
    }

    private DiscoveryNode getPrimaryNode(ShardId shardId) {
        ShardRouting primaryShard = this.clusterService.state().routingTable().shardRoutingTable(shardId).primaryShard();
        return this.clusterService.state().nodes().get(primaryShard.currentNodeId());
    }
}

