/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.checkpoint;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.common.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.index.shard.ShardId;

public class ReplicationCheckpoint
implements Writeable,
Comparable<ReplicationCheckpoint> {
    private final ShardId shardId;
    private final long primaryTerm;
    private final long segmentsGen;
    private final long segmentInfosVersion;
    private final long length;
    private final String codec;

    public static ReplicationCheckpoint empty(ShardId shardId, String codec) {
        return new ReplicationCheckpoint(shardId, codec);
    }

    private ReplicationCheckpoint(ShardId shardId, String codec) {
        this.shardId = shardId;
        this.primaryTerm = 0L;
        this.segmentsGen = -1L;
        this.segmentInfosVersion = -1L;
        this.length = 0L;
        this.codec = codec;
    }

    public ReplicationCheckpoint(ShardId shardId, long primaryTerm, long segmentsGen, long segmentInfosVersion, String codec) {
        this(shardId, primaryTerm, segmentsGen, segmentInfosVersion, 0L, codec);
    }

    public ReplicationCheckpoint(ShardId shardId, long primaryTerm, long segmentsGen, long segmentInfosVersion, long length, String codec) {
        this.shardId = shardId;
        this.primaryTerm = primaryTerm;
        this.segmentsGen = segmentsGen;
        this.segmentInfosVersion = segmentInfosVersion;
        this.length = length;
        this.codec = codec;
    }

    public ReplicationCheckpoint(StreamInput in) throws IOException {
        this.shardId = new ShardId(in);
        this.primaryTerm = in.readLong();
        this.segmentsGen = in.readLong();
        this.segmentInfosVersion = in.readLong();
        if (in.getVersion().onOrAfter(Version.V_2_7_0)) {
            this.length = in.readLong();
            this.codec = in.readString();
        } else {
            this.length = 0L;
            this.codec = null;
        }
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public long getSegmentsGen() {
        return this.segmentsGen;
    }

    public long getSegmentInfosVersion() {
        return this.segmentInfosVersion;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public long getLength() {
        return this.length;
    }

    public String getCodec() {
        return this.codec;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeLong(this.primaryTerm);
        out.writeLong(this.segmentsGen);
        out.writeLong(this.segmentInfosVersion);
        if (out.getVersion().onOrAfter(Version.V_2_7_0)) {
            out.writeLong(this.length);
            out.writeString(this.codec);
        }
    }

    @Override
    public int compareTo(ReplicationCheckpoint other) {
        return this.isAheadOf(other) ? -1 : 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationCheckpoint that = (ReplicationCheckpoint)o;
        return this.primaryTerm == that.primaryTerm && this.segmentsGen == that.segmentsGen && this.segmentInfosVersion == that.segmentInfosVersion && Objects.equals(this.shardId, that.shardId) && this.codec.equals(that.codec);
    }

    public int hashCode() {
        return Objects.hash(this.shardId, this.primaryTerm, this.segmentsGen);
    }

    public boolean isAheadOf(@Nullable ReplicationCheckpoint other) {
        return other == null || this.primaryTerm > other.getPrimaryTerm() || this.primaryTerm == other.getPrimaryTerm() && this.segmentInfosVersion > other.getSegmentInfosVersion();
    }

    public String toString() {
        return "ReplicationCheckpoint{shardId=" + this.shardId + ", primaryTerm=" + this.primaryTerm + ", segmentsGen=" + this.segmentsGen + ", version=" + this.segmentInfosVersion + ", size=" + this.length + ", codec=" + this.codec + "}";
    }
}

