/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.util.SetBackedScalingCuckooFilter;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.bucket.terms.InternalMappedRareTerms;
import org.opensearch.search.aggregations.bucket.terms.InternalRareTerms;

public class LongRareTerms
extends InternalMappedRareTerms<LongRareTerms, Bucket> {
    public static final String NAME = "lrareterms";

    LongRareTerms(String name, BucketOrder order, Map<String, Object> metadata, DocValueFormat format, List<Bucket> buckets, long maxDocCount, SetBackedScalingCuckooFilter filter) {
        super(name, order, metadata, format, buckets, maxDocCount, filter);
    }

    public LongRareTerms(StreamInput in) throws IOException {
        super(in, Bucket::new);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public LongRareTerms create(List<Bucket> buckets) {
        return new LongRareTerms(this.name, this.order, (Map<String, Object>)this.metadata, this.format, buckets, this.maxDocCount, this.filter);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.term, prototype.getDocCount(), aggregations, prototype.format);
    }

    @Override
    protected LongRareTerms createWithFilter(String name, List<Bucket> buckets, SetBackedScalingCuckooFilter filter) {
        return new LongRareTerms(name, this.order, this.getMetadata(), this.format, buckets, this.maxDocCount, filter);
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    @Override
    public boolean containsTerm(SetBackedScalingCuckooFilter filter, Bucket bucket) {
        return filter.mightContain((Long)bucket.getKey());
    }

    @Override
    public void addToFilter(SetBackedScalingCuckooFilter filter, Bucket bucket) {
        filter.add((Long)bucket.getKey());
    }

    @Override
    Bucket createBucket(long docCount, InternalAggregations aggs, Bucket prototype) {
        return new Bucket(prototype.term, docCount, aggs, this.format);
    }

    public static class Bucket
    extends InternalRareTerms.Bucket<Bucket> {
        long term;

        public Bucket(long term, long docCount, InternalAggregations aggregations, DocValueFormat format) {
            super(docCount, aggregations, format);
            this.term = term;
        }

        public Bucket(StreamInput in, DocValueFormat format) throws IOException {
            super(in, format);
            this.term = in.readLong();
        }

        @Override
        protected void writeTermTo(StreamOutput out) throws IOException {
            out.writeLong(this.term);
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.term).toString();
        }

        @Override
        public Object getKey() {
            return this.term;
        }

        @Override
        public Number getKeyAsNumber() {
            return this.term;
        }

        @Override
        public int compareKey(Bucket other) {
            return Long.compare(this.term, other.term);
        }

        @Override
        protected final XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.term);
            if (this.format != DocValueFormat.RAW) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.format.format(this.term).toString());
            }
            return builder;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.term, ((Bucket)obj).term);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.term);
        }
    }
}

